/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JList;

public class SlotClsesPanel
extends JComponent {
    private static final long serialVersionUID = 3204543839780790235L;
    private JList _list;

    public SlotClsesPanel(Project project) {
        this.setLayout(new BorderLayout());
        this._list = this.createList();
        LabeledComponent c = new LabeledComponent("Classes", ComponentFactory.createScrollPane(this._list));
        this.add(c);
    }

    private JList createList() {
        JList list = ComponentFactory.createList(ModalDialog.getCloseAction(this));
        list.setCellRenderer(FrameRenderer.createInstance());
        return list;
    }

    public void setSlot(Slot slot) {
        if (slot == null) {
            ComponentUtilities.setListValues(this._list, Collections.EMPTY_LIST);
        } else {
            Collection allClses = slot.getDirectDomain();
            if (slot.getKnowledgeBase().getProject().getDisplayHiddenClasses()) {
                ComponentUtilities.setListValues(this._list, allClses);
            } else {
                ArrayList<Cls> visibleClses = new ArrayList<Cls>();
                for (Cls cls : allClses) {
                    if (!cls.isVisible()) continue;
                    visibleClses.add(cls);
                }
                ComponentUtilities.setListValues(this._list, visibleClses);
            }
        }
    }
}

