/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import javax.swing.Icon;

public class SlotPairRenderer
extends DefaultRenderer
implements Cloneable {
    private static final long serialVersionUID = -4381654272891062203L;
    private static SlotPairRenderer _prototypeInstance = new SlotPairRenderer();

    public static SlotPairRenderer createInstance() {
        SlotPairRenderer result;
        try {
            result = (SlotPairRenderer)_prototypeInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.getLogger().warning(e.toString());
            result = _prototypeInstance;
        }
        return result;
    }

    public void load(Object value) {
        FrameSlotCombination combination = (FrameSlotCombination)value;
        Cls cls = (Cls)combination.getFrame();
        Slot slot = combination.getSlot();
        String text = slot.getBrowserText();
        boolean isInherited = !cls.hasDirectTemplateSlot(slot);
        boolean isReadonly = !cls.isEditable() || !slot.isEditable();
        boolean isOverridden = cls.hasDirectlyOverriddenTemplateSlot(slot);
        boolean isHidden = !slot.isVisible();
        Icon icon = Icons.getSlotIcon(isInherited, isOverridden, isReadonly, isHidden);
        this.setMainText(text);
        this.setMainIcon(icon);
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }

    public String getToolTipText() {
        FrameSlotCombination combination = (FrameSlotCombination)this.getValue();
        Cls cls = (Cls)combination.getFrame();
        Slot slot = combination.getSlot();
        StringBuffer buffer = new StringBuffer();
        SlotPairRenderer.appendInheritanceInformation(cls, slot, buffer);
        SlotPairRenderer.appendFacetOverrideInformation(cls, slot, buffer);
        String text = buffer.length() == 0 ? null : "<html>" + buffer.toString() + "</html>";
        return text;
    }

    private static void appendInheritanceInformation(Cls cls, Slot slot, StringBuffer buffer) {
        if (!cls.hasDirectTemplateSlot(slot)) {
            buffer.append("<b>");
            buffer.append(slot.getBrowserText());
            buffer.append("</b> is inherited from ");
            boolean first = true;
            for (Cls superClass : cls.getSuperclasses()) {
                if (!superClass.hasDirectTemplateSlot(slot)) continue;
                if (!first) {
                    buffer.append(" and ");
                }
                buffer.append("<b>");
                buffer.append(superClass.getBrowserText());
                buffer.append("</b>");
                first = false;
            }
        }
    }

    private static void appendFacetOverrideInformation(Cls cls, Slot slot, StringBuffer buffer) {
        Collection facets = cls.getDirectlyOverriddenTemplateFacets(slot);
        if (!facets.isEmpty()) {
            if (buffer.length() != 0) {
                buffer.append("<br>");
            }
            for (Facet facet : facets) {
                buffer.append("<b>");
                buffer.append(facet.getBrowserText());
                buffer.append("</b> is directly overridden");
                buffer.append("</br>");
            }
        }
    }

    public static void setPrototypeInstance(SlotPairRenderer renderer) {
        _prototypeInstance = renderer;
    }
}

