/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.Collection;
import java.util.Comparator;

public class SlotSubslotNode
extends LazyTreeNode {
    private FrameListener _frameListener = new FrameAdapter(){

        public void frameReplaced(FrameEvent event) {
            Frame oldFrame = event.getFrame();
            Frame newFrame = event.getNewFrame();
            Slot slot = SlotSubslotNode.this.getSlot();
            if (slot != null && slot.equals(oldFrame)) {
                SlotSubslotNode.this.reload(newFrame);
            }
        }

        public void browserTextChanged(FrameEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            SlotSubslotNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            String slotName = event.getSlot().getName();
            if (slotName.equals(":DIRECT-SUBSLOTS")) {
                SlotSubslotNode.this.reload();
            } else if (slotName.equals(":DIRECT-TYPE")) {
                Slot slot = SlotSubslotNode.this.getSlot().getKnowledgeBase().getSlot(SlotSubslotNode.this.getSlot().getName());
                SlotSubslotNode.this.reload(slot);
            }
        }
    };

    public SlotSubslotNode(LazyTreeNode parentNode, Slot parentSlot) {
        super(parentNode, parentSlot, parentNode.isSorted());
        parentSlot.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object o) {
        return new SlotSubslotNode((LazyTreeNode)this, (Slot)o);
    }

    protected void dispose() {
        super.dispose();
        this.getSlot().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        return this.getSlot().getDirectSubslotCount();
    }

    protected Collection getChildObjects() {
        return this.getSlot().getDirectSubslots();
    }

    protected Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected Slot getSlot() {
        return (Slot)this.getUserObject();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    public String toString() {
        return "SlotSubslotNode(" + this.getSlot() + ")";
    }
}

