/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.SlotAdapter;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.ui.SlotSubslotNode;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SlotSubslotRoot
extends LazyTreeRoot {
    private KnowledgeBase _knowledgeBase;
    private KnowledgeBaseListener _listener = new KnowledgeBaseAdapter(){

        public void slotCreated(KnowledgeBaseEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            super.slotCreated(event);
            Slot slot = event.getSlot();
            if (slot.getDirectSuperslots().isEmpty()) {
                List slots = (List)SlotSubslotRoot.this.getUserObject();
                int index = 0;
                slots.add(index, slot);
                SlotSubslotRoot.this.childAdded(slot, index);
                if (SlotSubslotRoot.this.getChildCount() == 1) {
                    SlotSubslotRoot.this.notifyNodeStructureChanged(SlotSubslotRoot.this);
                }
            }
        }

        public void slotDeleted(KnowledgeBaseEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            super.slotDeleted(event);
            Slot slot = event.getSlot();
            List slots = (List)SlotSubslotRoot.this.getUserObject();
            boolean changed = slots.remove(slot);
            if (changed) {
                SlotSubslotRoot.this.childRemoved(slot);
            }
        }
    };
    private SlotListener _slotListener = new SlotAdapter(){

        public void directSuperslotAdded(SlotEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            Slot slot = event.getSlot();
            if (slot.getDirectSuperslotCount() == 1) {
                SlotSubslotRoot.this.removeChild(slot);
            }
        }

        public void directSuperslotRemoved(SlotEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            Slot slot = event.getSlot();
            if (slot.getDirectSuperslotCount() == 0) {
                SlotSubslotRoot.this.addChild(slot);
            }
        }
    };

    private void removeChild(Slot slot) {
        List slots = (List)this.getUserObject();
        slots.remove(slot);
        this.childRemoved(slot);
    }

    private void addChild(Slot slot) {
        List slots = (List)this.getUserObject();
        slots.add(slot);
        this.childAdded(slot);
    }

    public SlotSubslotRoot(KnowledgeBase kb) {
        this(kb, SlotSubslotRoot.getSlots(kb));
    }

    public SlotSubslotRoot(KnowledgeBase kb, Collection slots) {
        this(kb, slots, ApplicationProperties.getSortSlotTreeOption());
    }

    public SlotSubslotRoot(KnowledgeBase kb, Collection slots, boolean isSorted) {
        super(slots);
        kb.addKnowledgeBaseListener(this._listener);
        kb.addSlotListener(this._slotListener);
        this._knowledgeBase = kb;
    }

    public LazyTreeNode createNode(Object o) {
        return new SlotSubslotNode((LazyTreeNode)this, (Slot)o);
    }

    public void dispose() {
        super.dispose();
        this._knowledgeBase.removeKnowledgeBaseListener(this._listener);
        this._knowledgeBase.removeSlotListener(this._slotListener);
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    private static Collection getSlots(KnowledgeBase kb) {
        ArrayList results = new ArrayList(kb.getSlots());
        Iterator i = results.iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (slot.getDirectSuperslotCount() <= 0) continue;
            i.remove();
        }
        if (ApplicationProperties.getSortSlotTreeOption()) {
            Collections.sort(results, new FrameComparator());
        }
        return results;
    }
}

