/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FrameTreeFinder;
import java.util.Collection;
import javax.swing.JTree;

public class SlotsTreeFinder
extends FrameTreeFinder {
    private static final long serialVersionUID = -7353189621803272208L;

    public SlotsTreeFinder(KnowledgeBase kb, JTree tree) {
        super(kb, tree, ResourceKey.SLOT_SEARCH_FOR);
    }

    public SlotsTreeFinder(KnowledgeBase kb, JTree tree, String description) {
        super(kb, tree, description, Icons.getFindSlotIcon());
    }

    protected Collection getParents(Frame frame) {
        return ((Slot)frame).getDirectSuperslots();
    }

    protected Collection getAncestors(Frame frame) {
        return ((Slot)frame).getSuperslots();
    }

    protected boolean isCorrectType(Frame frame) {
        return frame instanceof Slot;
    }

    protected Slot getBrowserSlot(KnowledgeBase kb) {
        Cls cls = kb.getDefaultSlotMetaCls();
        Slot slot = cls == null ? kb.getNameSlot() : cls.getBrowserSlotPattern().getFirstSlot();
        return slot;
    }
}

