/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.TreeTarget;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SlotsTreeTarget
extends TreeTarget {
    public SlotsTreeTarget() {
        super(true);
    }

    private static boolean addSuperslot(Slot source, Slot parent) {
        boolean succeeded = false;
        if (parent != source && !parent.hasSuperslot(source) && !source.hasDirectSuperslot(parent)) {
            source.addDirectSuperslot(parent);
            succeeded = true;
        }
        return succeeded;
    }

    public boolean doDrop(JTree tree, Object source, int targetRow, Object area) {
        LazyTreeNode parentNode;
        boolean succeeded = false;
        TreePath path = tree.getPathForRow(targetRow);
        LazyTreeNode targetNode = (LazyTreeNode)path.getLastPathComponent();
        Slot targetSlot = (Slot)targetNode.getUserObject();
        Slot sourceSlot = (Slot)source;
        boolean addedSuperslot = false;
        if (area == DefaultRenderer.DROP_TARGET_AREA_ON) {
            parentNode = targetNode;
            addedSuperslot = succeeded = SlotsTreeTarget.addSuperslot(sourceSlot, targetSlot);
        } else {
            parentNode = sourceSlot.hasDirectSuperslot(targetSlot) ? targetNode : targetNode.getLazyTreeNodeParent();
            boolean isOK = true;
            Object parentObject = parentNode.getUserObject();
            if (parentObject instanceof Slot) {
                Slot parentSlot = (Slot)parentObject;
                if (!sourceSlot.hasDirectSuperslot(parentSlot)) {
                    addedSuperslot = isOK = SlotsTreeTarget.addSuperslot(sourceSlot, parentSlot);
                }
                if (isOK) {
                    parentSlot.moveDirectSubslot(sourceSlot, targetSlot);
                    succeeded = true;
                }
            }
        }
        if (succeeded) {
            int newIndex = parentNode.getUserObjectIndex(sourceSlot);
            TreeNode newNode = parentNode.getChildAt(newIndex);
            ComponentUtilities.setSelectedNode(tree, newNode);
        }
        return succeeded && addedSuperslot;
    }

    public String toString() {
        return "ClsesTreeTarget";
    }
}

