/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.ClsesTreeDragSourceListener;
import edu.stanford.smi.protege.ui.ClsesTreeTarget;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SuperclassTraverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class SubclassPane
extends SelectableContainer {
    private static final long serialVersionUID = 5266489572482981600L;
    private KnowledgeBase _knowledgeBase;
    private Action _createClsAction;
    private Action _deleteClsAction;
    private static final int MAX_EXPANSIONS = 1000;

    public SubclassPane(Action doubleClickAction, Cls rootCls, Action createCls, Action deleteCls) {
        this._knowledgeBase = rootCls.getKnowledgeBase();
        this._createClsAction = createCls;
        this._deleteClsAction = deleteCls;
        SelectableTree tree = this.createSelectableTree(doubleClickAction, rootCls);
        tree.setLargeModel(true);
        tree.setSelectionRow(0);
        tree.setAutoscrolls(true);
        this.setSelectable(tree);
        this.setLayout(new BorderLayout());
        JScrollPane pane = ComponentFactory.createScrollPane(tree);
        this.add((Component)pane, "Center");
        this.add((Component)new ClsTreeFinder(this._knowledgeBase, tree), "South");
        this.setupDragAndDrop();
        this.getTree().setCellRenderer(FrameRenderer.createInstance());
        this.getTree().addMouseListener(new TreePopupMenuMouseListener(tree){

            public JPopupMenu getPopupMenu() {
                return SubclassPane.this.getPopupMenu();
            }
        });
    }

    protected SelectableTree createSelectableTree(Action doubleClickAction, Cls rootCls) {
        return ComponentFactory.createSelectableTree(doubleClickAction, new ParentChildRoot(rootCls));
    }

    private Action createCollapseAllAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_COLLAPSE_TREE_MENU_ITEM){
            private static final long serialVersionUID = -5294993636227782853L;

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionCollapse(SubclassPane.this.getTree());
            }
        };
    }

    private Action createExpandAllAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_EXPAND_TREE_MENU_ITEM){
            private static final long serialVersionUID = -3462333994306988331L;

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionExpand(SubclassPane.this.getTree(), 1000);
            }
        };
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = null;
        if (!this.getSelection().isEmpty()) {
            menu = new JPopupMenu();
            SubclassPane.add(menu, this._createClsAction);
            SubclassPane.add(menu, this.getCreateClsWithMetaClsAction());
            SubclassPane.add(menu, this._deleteClsAction);
            SubclassPane.addSeparator(menu);
            SubclassPane.add(menu, this.getChangeMetaclassAction());
            SubclassPane.add(menu, this.getChangeSubclassMetaclassAction());
            SubclassPane.addSeparator(menu);
            SubclassPane.add(menu, this.getHideClsAction());
            SubclassPane.addSeparator(menu);
            SubclassPane.add(menu, this.createSetClsMetaClsAction());
            SubclassPane.add(menu, this.createSetSlotMetaClsAction());
            SubclassPane.addSeparator(menu);
            SubclassPane.add(menu, this.createExpandAllAction());
            SubclassPane.add(menu, this.createCollapseAllAction());
        }
        return menu;
    }

    private static void add(JPopupMenu menu, Action action) {
        menu.add(action);
    }

    private static void addSeparator(JPopupMenu menu) {
        int count = menu.getComponentCount();
        Component c = menu.getComponent(count - 1);
        if (!(c instanceof JSeparator)) {
            menu.addSeparator();
        }
    }

    private Action createSetClsMetaClsAction() {
        final Cls cls = (Cls)this.getSoleSelection();
        StandardAction action = new StandardAction(ResourceKey.CLASS_BROWSER_SET_AS_DEFAULT_METACLASS_MENU_ITEM){
            private static final long serialVersionUID = -2802257939885292526L;

            public void actionPerformed(ActionEvent event) {
                SubclassPane.this._knowledgeBase.setDefaultClsMetaCls(cls);
                SubclassPane.this.repaint();
            }
        };
        boolean enabled = cls != null && cls.isClsMetaCls() && !cls.isDefaultClsMetaCls() && cls.isConcrete();
        action.setEnabled(enabled);
        return action;
    }

    private Action createSetSlotMetaClsAction() {
        final Cls cls = (Cls)this.getSoleSelection();
        final boolean isDefault = cls != null && cls.isDefaultSlotMetaCls();
        ResourceKey key = isDefault ? ResourceKey.CLASS_BROWSER_UNSET_AS_DEFAULT_METASLOT_MENU_ITEM : ResourceKey.CLASS_BROWSER_SET_AS_DEFAULT_METASLOT_MENU_ITEM;
        StandardAction action = new StandardAction(key){
            private static final long serialVersionUID = 7802992328694807093L;

            public void actionPerformed(ActionEvent event) {
                SubclassPane.this._knowledgeBase.setDefaultSlotMetaCls(isDefault ? null : cls);
                SubclassPane.this.repaint();
            }
        };
        boolean enabled = isDefault || cls != null && cls.isSlotMetaCls() && cls.isConcrete();
        action.setEnabled(enabled);
        return action;
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection(this.getTree(), cls);
    }

    private Action getChangeMetaclassAction() {
        StandardAction action = new StandardAction(ResourceKey.CLASS_BROWSER_CHANGE_METACLASS_MENU_ITEM){
            private static final long serialVersionUID = 1762699423996754665L;

            public void actionPerformed(ActionEvent event) {
                Collection<Cls> clsMetaClses = CollectionUtilities.createCollection(SubclassPane.this._knowledgeBase.getRootClsMetaCls());
                Cls metaclass = SubclassPane.this.pickConcreteCls(clsMetaClses, "Select Concrete Metaclass");
                if (metaclass != null) {
                    for (Cls cls : SubclassPane.this.getSelection()) {
                        if (metaclass.equals(cls.getDirectType())) continue;
                        cls.setDirectType(metaclass);
                    }
                }
            }
        };
        action.setEnabled(this.canChangeMetaCls());
        return action;
    }

    private boolean canChangeMetaCls() {
        Cls rootMetaclass = this._knowledgeBase.getRootClsMetaCls();
        Collection<Cls> c = CollectionUtilities.createCollection(rootMetaclass);
        boolean hasMultipleMetaclasses = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, c);
        return hasMultipleMetaclasses && this.selectionIsEditable();
    }

    private boolean selectionIsEditable() {
        boolean isEditable = true;
        Iterator i = this.getSelection().iterator();
        while (i.hasNext() && isEditable) {
            Frame frame = (Frame)i.next();
            isEditable = frame.isEditable();
        }
        return isEditable;
    }

    protected Cls pickConcreteCls(Collection allowedClses, String text) {
        return DisplayUtilities.pickConcreteCls(this, this._knowledgeBase, allowedClses, text);
    }

    private Action getChangeSubclassMetaclassAction() {
        Cls rootMetaclass = this._knowledgeBase.getRootClsMetaCls();
        Collection<Cls> c = CollectionUtilities.createCollection(rootMetaclass);
        boolean hasMultipleMetaclasses = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, c);
        final Cls cls = (Cls)this.getSoleSelection();
        StandardAction action = new StandardAction(ResourceKey.CLASS_BROWSER_CHANGE_METACLASS_OF_SUBCLASSES_MENU_ITEM){
            private static final long serialVersionUID = -1533419814130384712L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                Cls metaCls = cls.getDirectType();
                String text = "Change metaclass of all subclasses of ";
                text = text + cls.getName();
                int result = ModalDialog.showMessageDialog((Component)SubclassPane.this, text = text + " to " + metaCls.getName(), 11);
                if (result == 1) {
                    WaitCursor waitCursor = new WaitCursor(SubclassPane.this);
                    try {
                        cls.setDirectTypeOfSubclasses(metaCls);
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            }
        };
        boolean enabled = cls != null && hasMultipleMetaclasses && cls.getDirectSubclassCount() >= 1;
        action.setEnabled(enabled);
        return action;
    }

    private Action getCreateClsWithMetaClsAction() {
        StandardAction action = new StandardAction(ResourceKey.CLASS_BROWSER_CREATE_SUBCLASS_USING_METACLASS_MENU_ITEM){
            private static final long serialVersionUID = 1596972416401713147L;

            public void actionPerformed(ActionEvent event) {
                Cls rootMetaCls = SubclassPane.this._knowledgeBase.getRootClsMetaCls();
                Collection<Cls> roots = CollectionUtilities.createCollection(rootMetaCls);
                Cls metaCls = SubclassPane.this.pickConcreteCls(roots, "Select Metaclass");
                Collection parents = SubclassPane.this.getSelection();
                if (metaCls != null && !parents.isEmpty()) {
                    Cls cls = SubclassPane.this._knowledgeBase.createCls(null, parents, metaCls);
                    SubclassPane.this.extendSelection(cls);
                }
            }
        };
        boolean enabled = this.hasMultipleConcreteClsMetaClses();
        action.setEnabled(enabled);
        return action;
    }

    public Cls getDisplayParent() {
        TreePath path = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        return o instanceof Cls ? (Cls)o : null;
    }

    public JComponent getDropComponent() {
        return this.getTree();
    }

    private Action getHideClsAction() {
        final Cls cls = (Cls)this.getSoleSelection();
        final boolean hide = cls == null || cls.isVisible();
        ResourceKey key = hide ? ResourceKey.CLASS_BROWSER_HIDE_CLASS_MENU_ITEM : ResourceKey.CLASS_BROWSER_UNHIDE_CLASS_MENU_ITEM;
        return new StandardAction(key){
            private static final long serialVersionUID = -8865114599879876460L;

            public void actionPerformed(ActionEvent event) {
                cls.setVisible(!hide);
                SubclassPane.this.repaint();
            }
        };
    }

    private JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    private JTree getTree() {
        return (JTree)((Object)this.getSelectable());
    }

    private boolean hasMultipleConcreteClsMetaClses() {
        Cls standardCls = this._knowledgeBase.getCls(":STANDARD-CLASS");
        return standardCls.getDirectSubclassCount() > 0;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection(this.getTree());
    }

    public void setExpandedCls(Cls cls, boolean expanded) {
        List<Cls> path = ModelUtilities.getPathToRoot(cls);
        ComponentUtilities.setExpanded(this.getTree(), path, expanded);
    }

    public void setFinderComponent(JComponent c) {
        this.add((Component)c, "South");
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer(renderer);
    }

    public void setSelectedCls(Cls cls) {
        if (!this.getSelection().contains(cls)) {
            List<Cls> path = ModelUtilities.getPathToRoot(cls);
            ComponentUtilities.setSelectedObjectPath(this.getTree(), path);
        }
    }

    public void setSelectedClses(Collection clses) {
        ArrayList<List<Cls>> paths = new ArrayList<List<Cls>>();
        for (Object o : clses) {
            if (!(o instanceof Cls)) continue;
            Cls cls = (Cls)o;
            paths.add(ModelUtilities.getPathToRoot(cls));
        }
        ComponentUtilities.setSelectedObjectPaths(this.getTree(), paths);
    }

    protected void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 3, new ClsesTreeDragSourceListener());
        new DropTarget(this.getTree(), 3, new ClsesTreeTarget());
    }

    public void setDisplayParent(Cls cls) {
        ComponentUtilities.setDisplayParent(this.getTree(), cls, new SuperclassTraverser());
    }

    public String toString() {
        return "SubclassPane";
    }

    public void dispose() {
        ((SelectableTree)this.getSelectable()).setRoot(null);
        ((SelectableTree)this.getSelectable()).setModel(null);
        this._knowledgeBase = null;
        super.dispose();
    }
}

