/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.SlotHierarchyRenderer;
import edu.stanford.smi.protege.ui.SlotSubslotRoot;
import edu.stanford.smi.protege.ui.SlotsTreeDragSourceListener;
import edu.stanford.smi.protege.ui.SlotsTreeFinder;
import edu.stanford.smi.protege.ui.SlotsTreeTarget;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SuperslotTraverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class SubslotPane
extends SelectableContainer {
    private static final long serialVersionUID = 7779648620738685152L;
    private Project _project;
    private KnowledgeBase _knowledgeBase;
    private Action _createSlotAction;
    private Action _createSubslotAction;
    private Action _deleteSlotAction;
    private Action _viewSlotAction;
    private LabeledComponent _labeledComponent;
    private static final int MAX_EXPANSIONS = 100;

    public SubslotPane(Project p) {
        this._project = p;
        this._knowledgeBase = this._project.getKnowledgeBase();
        this._createSlotAction = this.getCreateAction();
        this._deleteSlotAction = this.getDeleteAction();
        this._createSubslotAction = this.getCreateSubslotAction();
        this._viewSlotAction = this.getViewAction();
        LazyTreeRoot root = this.createRoot(this._knowledgeBase);
        SelectableTree tree = ComponentFactory.createSelectableTree(this._viewSlotAction, root);
        tree.setCellRenderer(new SlotHierarchyRenderer());
        tree.setShowsRootHandles(true);
        tree.setSelectionRow(0);
        tree.setLargeModel(true);
        this.setSelectable(tree);
        this.setLayout(new BorderLayout());
        String slotHierarchyLabel = LocalizedText.getText(ResourceKey.SLOT_BROWSER_HIERARCHY_LABEL);
        this._labeledComponent = new LabeledComponent(slotHierarchyLabel, ComponentFactory.createScrollPane(tree));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.addButtons(this._labeledComponent);
        this.add((Component)this.createHeader(), "North");
        this.add((Component)this._labeledComponent, "Center");
        this.add((Component)new SlotsTreeFinder(this._knowledgeBase, tree), "South");
        tree.addMouseListener(new TreePopupMenuMouseListener(tree){

            public JPopupMenu getPopupMenu() {
                return SubslotPane.this.getPopupMenu();
            }
        });
        this.setupDragAndDrop();
        this._viewSlotAction.setEnabled(true);
        this._deleteSlotAction.setEnabled(true);
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    private JComponent createHeader() {
        JLabel label = ComponentFactory.createLabel(Icons.getProjectIcon());
        label.setText(this._project.getName());
        String slotBrowserLabel = LocalizedText.getText(ResourceKey.SLOT_BROWSER_TITLE);
        String forProjectLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent header = new HeaderComponent(slotBrowserLabel, forProjectLabel, label);
        header.setColor(Colors.getSlotColor());
        return header;
    }

    protected LazyTreeRoot createRoot(KnowledgeBase kb) {
        return new SlotSubslotRoot(kb);
    }

    protected void addButtons(LabeledComponent c) {
        c.addHeaderButton(this._viewSlotAction);
        c.addHeaderButton(this._createSlotAction);
        c.addHeaderButton(this._deleteSlotAction);
    }

    protected Action createCollapseAllAction() {
        return new AbstractAction("Collapse"){
            private static final long serialVersionUID = 1348386770476732031L;

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionCollapse(SubslotPane.this.getTree());
            }
        };
    }

    protected Action createExpandAllAction() {
        return new AbstractAction("Expand"){
            private static final long serialVersionUID = -4254186270874090400L;

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionExpand(SubslotPane.this.getTree(), 100);
            }
        };
    }

    public void extendSelection(Slot slot) {
        ComponentUtilities.extendSelection(this.getTree(), slot);
    }

    protected Action getChangeSlotMetaclassAction(final Slot slot) {
        Cls rootMetaclass = this._knowledgeBase.getRootSlotMetaCls();
        final Collection<Cls> c = CollectionUtilities.createCollection(rootMetaclass);
        boolean hasMultipleMetaclasses = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, c);
        AbstractAction action = new AbstractAction("Change slot metaclass..."){
            private static final long serialVersionUID = 1869916325108349252L;

            public void actionPerformed(ActionEvent event) {
                Cls metaclass = SubslotPane.this.pickConcreteCls(c, "Select Slot Metaclass");
                if (metaclass != null && !metaclass.equals(slot.getDirectType())) {
                    slot.setDirectType(metaclass);
                }
            }
        };
        action.setEnabled(hasMultipleMetaclasses && slot.isEditable());
        return action;
    }

    protected Cls pickConcreteCls(Collection allowedClses, String text) {
        return DisplayUtilities.pickConcreteCls(this, this._knowledgeBase, allowedClses, text);
    }

    protected Action getChangeSubslotSlotMetaclassAction(final Slot slot) {
        Cls rootMetaclass = this._knowledgeBase.getRootSlotMetaCls();
        Collection<Cls> c = CollectionUtilities.createCollection(rootMetaclass);
        boolean hasMultipleMetaclasses = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, c);
        AbstractAction action = new AbstractAction("Change slot metaclass of subslots"){
            private static final long serialVersionUID = -5279771465147048253L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                Cls metaCls = slot.getDirectType();
                String text = "Change slot metaclass of all subslots of ";
                text = text + slot.getName();
                int result = ModalDialog.showMessageDialog((Component)SubslotPane.this, text = text + " to " + metaCls.getName(), 11);
                if (result == 1) {
                    WaitCursor waitCursor = new WaitCursor(SubslotPane.this);
                    try {
                        slot.setDirectTypeOfSubslots(metaCls);
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            }
        };
        boolean enabled = slot.isEditable() && hasMultipleMetaclasses && slot.getDirectSubslotCount() >= 1;
        action.setEnabled(enabled);
        return action;
    }

    protected Action getCreateAction() {
        return new CreateAction(ResourceKey.SLOT_CREATE){
            private static final long serialVersionUID = -1623934054467544637L;

            public void onCreate() {
                Transaction<Slot> t = new Transaction<Slot>(SubslotPane.this._knowledgeBase, "Create Slot (random name)"){
                    private Slot slot;

                    @Override
                    public boolean doOperations() {
                        this.slot = SubslotPane.this._knowledgeBase.createSlot(null);
                        return true;
                    }

                    @Override
                    public Slot getResult() {
                        return this.slot;
                    }
                };
                t.execute();
                SubslotPane.this.setSelectedSlot((Slot)t.getResult());
            }
        };
    }

    protected Action getCreateSlotWithSlotMetaclassAction() {
        AbstractAction action = new AbstractAction("Create subslot using slot metaclass..."){
            private static final long serialVersionUID = 3598104978460935980L;

            public void actionPerformed(ActionEvent event) {
                Cls rootMetaCls = SubslotPane.this._knowledgeBase.getRootSlotMetaCls();
                Collection<Cls> roots = CollectionUtilities.createCollection(rootMetaCls);
                Cls metaCls = SubslotPane.this.pickConcreteCls(roots, "Select Slot Metaclass");
                Collection parents = SubslotPane.this.getSelection();
                if (metaCls != null && !parents.isEmpty()) {
                    Slot slot = SubslotPane.this._knowledgeBase.createSlot(null, metaCls, parents, true);
                    SubslotPane.this.extendSelection(slot);
                }
            }
        };
        boolean enabled = this.hasMultipleConcreteSlotMetaClses();
        action.setEnabled(enabled);
        return action;
    }

    protected Action getCreateSubslotAction() {
        return new CreateAction(ResourceKey.SLOT_CREATE_SUBSLOT){
            private static final long serialVersionUID = -2902180791403135103L;

            public void onCreate() {
                Collection superslots = SubslotPane.this.getSelection();
                Slot firstSuperslot = (Slot)CollectionUtilities.getFirstItem(superslots);
                if (firstSuperslot != null) {
                    try {
                        SubslotPane.this._knowledgeBase.beginTransaction("Create subslot of " + superslots);
                        Cls metaCls = firstSuperslot.getDirectType();
                        Slot slot = SubslotPane.this._knowledgeBase.createSlot(null, metaCls, superslots, true);
                        SubslotPane.this.createInverseSlot(slot, superslots);
                        SubslotPane.this._knowledgeBase.commitTransaction();
                        SubslotPane.this.extendSelection(slot);
                    }
                    catch (Exception e) {
                        SubslotPane.this._knowledgeBase.rollbackTransaction();
                        Log.getLogger().warning("Error at creating subslot of " + firstSuperslot);
                    }
                }
            }
        };
    }

    private void createInverseSlot(Slot slot, Collection superslots) {
        ArrayList<Slot> superInverses = new ArrayList<Slot>();
        Cls metaCls = null;
        for (Slot superslot : superslots) {
            Slot inverse = superslot.getInverseSlot();
            if (inverse == null) continue;
            superInverses.add(inverse);
            if (metaCls != null) continue;
            metaCls = inverse.getDirectType();
        }
        if (!superInverses.isEmpty()) {
            Slot inverse = this._knowledgeBase.createSlot("inverse_of_" + slot.getName(), metaCls, superInverses, true);
            slot.setInverseSlot(inverse);
        }
    }

    protected Action getDeleteAction() {
        return new DeleteAction(ResourceKey.SLOT_DELETE, (Selectable)this){
            private static final long serialVersionUID = 4967576578770750208L;

            public void onDelete(Collection slots) {
                SubslotPane.this.handleDelete(slots);
            }

            public void onSelectionChange() {
                Slot slot = (Slot)CollectionUtilities.getFirstItem(this.getSelection());
                if (slot != null) {
                    this.setAllowed(slot.isEditable());
                }
            }
        };
    }

    protected void handleDelete(Collection slots) {
        this.removeSelection();
        try {
            this._knowledgeBase.beginTransaction("Delete slots " + slots);
            for (Slot slot : slots) {
                this._knowledgeBase.deleteSlot(slot);
            }
            this._knowledgeBase.commitTransaction();
        }
        catch (Exception e) {
            this._knowledgeBase.rollbackTransaction();
            Log.getLogger().warning("Error at deleting slots " + slots);
        }
    }

    public Slot getDisplayParent() {
        TreePath path;
        Slot slot = null;
        TreePath childPath = this.getTree().getSelectionModel().getLeadSelectionPath();
        if (childPath != null && (path = childPath.getParentPath()) != null) {
            LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            slot = o instanceof Slot ? (Slot)o : null;
        }
        return slot;
    }

    public JTree getDropComponent() {
        return this.getTree();
    }

    public List getPath(Slot slot, List list) {
        list.add(0, slot);
        Slot superslot = (Slot)CollectionUtilities.getFirstItem(slot.getDirectSuperslots());
        if (superslot != null) {
            this.getPath(superslot, list);
        }
        return list;
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu menu = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            Slot slot = (Slot)CollectionUtilities.getFirstItem(selection);
            menu = new JPopupMenu();
            menu.add(this._createSlotAction);
            menu.add(this._createSubslotAction);
            menu.add(this.getCreateSlotWithSlotMetaclassAction());
            menu.add(this._deleteSlotAction);
            menu.addSeparator();
            menu.add(this.getChangeSlotMetaclassAction(slot));
            menu.add(this.getChangeSubslotSlotMetaclassAction(slot));
            menu.addSeparator();
            menu.add(this.createExpandAllAction());
            menu.add(this.createCollapseAllAction());
        }
        return menu;
    }

    private JTree getTree() {
        return (JTree)((Object)this.getSelectable());
    }

    protected Action getViewAction() {
        return new ViewAction(ResourceKey.SLOT_VIEW, (Selectable)this){
            private static final long serialVersionUID = -8304507739111498105L;

            public void onView(Object o) {
                SubslotPane.this._project.show((Slot)o);
            }
        };
    }

    private boolean hasMultipleConcreteSlotMetaClses() {
        int nConcrete = 0;
        Collection metaClses = this._knowledgeBase.getRootSlotMetaCls().getSubclasses();
        Iterator i = metaClses.iterator();
        while (i.hasNext() && nConcrete < 2) {
            Cls cls = (Cls)i.next();
            if (!cls.isConcrete()) continue;
            ++nConcrete;
        }
        return nConcrete > 1;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection(this.getTree());
    }

    public void setExpandedSlot(Slot slot, boolean expanded) {
        ComponentUtilities.setExpanded(this.getTree(), this.getPath(slot, new LinkedList()), expanded);
    }

    public void setFinderComponent(JComponent c) {
        this.add((Component)c, "South");
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer(renderer);
    }

    public void setSelectedSlot(Slot slot) {
        if (!this.getSelection().contains(slot)) {
            ComponentUtilities.setSelectedObjectPath(this.getTree(), this.getPath(slot, new LinkedList()));
        }
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 3, new SlotsTreeDragSourceListener());
        new DropTarget(this.getTree(), 3, new SlotsTreeTarget());
    }

    public void setDisplayParent(Slot slot) {
        ComponentUtilities.setDisplayParent(this.getTree(), slot, new SuperslotTraverser());
    }

    public String toString() {
        return "SubclassPane";
    }

    public void dispose() {
        super.dispose();
        this._project = null;
        this._knowledgeBase = null;
    }
}

