/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.TabWidget;

class TabRenderer
extends DefaultRenderer {
    private static final long serialVersionUID = 2875667491321456107L;
    private ProjectView projectView;

    TabRenderer(ProjectView view) {
        this.projectView = view;
    }

    public void load(Object o) {
        if (o instanceof WidgetDescriptor) {
            WidgetDescriptor d = (WidgetDescriptor)o;
            String longClassName = d.getWidgetClassName();
            TabWidget tab = this.projectView.getTabByClassName(longClassName);
            if (tab == null) {
                String shortClassName = StringUtilities.getShortClassName(longClassName);
                if (shortClassName.endsWith("Tab")) {
                    shortClassName = shortClassName.substring(0, shortClassName.length() - 3);
                }
                this.setMainText(shortClassName);
                this.setMainIcon(null);
            } else {
                this.setMainText(tab.getLabel());
                this.setMainIcon(tab.getIcon());
            }
        } else {
            this.setMainText(o.toString());
        }
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

