/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.DefaultRenderer;
import java.util.Collection;

public class TypeFacetRenderer
extends DefaultRenderer {
    private static final long serialVersionUID = -7154991031361614206L;

    public void load(Object o) {
        FrameSlotCombination combination = (FrameSlotCombination)o;
        Cls cls = (Cls)combination.getFrame();
        Slot slot = combination.getSlot();
        ValueType type = cls.getTemplateSlotValueType(slot);
        String text = type.toString();
        if (type == ValueType.INSTANCE) {
            Collection clses = cls.getTemplateSlotAllowedClses(slot);
            text = TypeFacetRenderer.append(text, "of", clses);
        } else if (type == ValueType.CLS) {
            Collection clses = cls.getTemplateSlotAllowedParents(slot);
            text = TypeFacetRenderer.append(text, "with superclass", clses);
        }
        this.setMainText(text);
        this.setGrayedText(!combination.getFrame().isEditable());
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }

    private static String append(String text, String separator, Collection clses) {
        if (!clses.isEmpty()) {
            text = text + " " + separator + " ";
            boolean first = true;
            for (Cls cls : clses) {
                if (!first) {
                    text = text + " or ";
                }
                first = false;
                text = text + cls.getBrowserText();
            }
        }
        return text;
    }
}

