/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.TabRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewSelector
extends JComponent {
    private static final long serialVersionUID = 296789933860074572L;
    private JComboBox combobox;
    private ProjectView projectView;
    private ItemListener itemListener = this.createChangeViewAction();
    private JToolBar toolBar;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Map descriptorToButtonMap = new HashMap();

    public ViewSelector(ProjectView projectView) {
        this.projectView = projectView;
        this.setLayout(new FlowLayout(0));
        this.combobox = ComponentFactory.createComboBox();
        ComboBoxModel model = this.createModel();
        this.combobox.setModel(model);
        this.combobox.addItemListener(this.itemListener);
        this.setOpaque(false);
        this.combobox.setRenderer(new TabRenderer(projectView));
        this.combobox.setPreferredSize(new Dimension(150, 10));
        Box box = Box.createHorizontalBox();
        box.add(ComponentFactory.createLabel("View:"));
        box.add(Box.createHorizontalStrut(2));
        box.add(this.combobox);
        box.add(Box.createHorizontalStrut(3));
        this.toolBar = ComponentFactory.createToolBar();
        this.addButtonsToToolbar();
        box.add(this.toolBar);
        this.add(box);
        projectView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TabWidget widget = ViewSelector.this.projectView.getSelectedTab();
                if (widget != null) {
                    ViewSelector.this.setSelection(widget);
                }
            }
        });
    }

    private void addButtonsToToolbar() {
        for (WidgetDescriptor d : this.getCurrentDescriptors()) {
            this.addButtonForExistingTab(d);
        }
    }

    public void reload() {
        this.descriptorToButtonMap.clear();
        this.buttonGroup = new ButtonGroup();
        this.toolBar.removeAll();
        this.addButtonsToToolbar();
    }

    private ComboBoxModel createModel() {
        Project project = this.projectView.getProject();
        Collection<WidgetDescriptor> tabs = project.getTabWidgetDescriptors();
        ArrayList modelElements = new ArrayList();
        modelElements.addAll(this.getCurrentDescriptors());
        modelElements.addAll(this.getPotentialDescriptors(tabs));
        return new DefaultComboBoxModel<Object>(modelElements.toArray());
    }

    private Collection getCurrentDescriptors() {
        ArrayList<WidgetDescriptor> currentDescriptors = new ArrayList<WidgetDescriptor>();
        for (TabWidget tab : this.projectView.getTabs()) {
            WidgetDescriptor d = tab.getDescriptor();
            currentDescriptors.add(d);
        }
        return currentDescriptors;
    }

    private Collection getPotentialDescriptors(Collection tabDescriptors) {
        ArrayList<WidgetDescriptor> potentialTabs = new ArrayList<WidgetDescriptor>();
        for (WidgetDescriptor d : tabDescriptors) {
            String className = d.getWidgetClassName();
            TabWidget tab = this.projectView.getTabByClassName(className);
            if (tab != null) continue;
            ArrayList errors = new ArrayList();
            if (!WidgetUtilities.isSuitableTab(className, this.projectView.getProject(), errors)) continue;
            potentialTabs.add(d);
        }
        return potentialTabs;
    }

    private ItemListener createChangeViewAction() {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WidgetDescriptor d = (WidgetDescriptor)e.getItem();
                    ViewSelector.this.showView(d);
                }
            }
        };
    }

    private void showView(WidgetDescriptor descriptor) {
        AbstractButton button = (AbstractButton)this.descriptorToButtonMap.get(descriptor);
        if (button == null) {
            button = this.addButton(descriptor.getWidgetClassName());
        }
        button.doClick();
    }

    public void addButtonForExistingTab(WidgetDescriptor d) {
        TabWidget widget = this.projectView.getTabByClassName(d.getWidgetClassName());
        AbstractButton button = this.addButton(widget);
        if (this.projectView.getSelectedTab() == widget) {
            button.setSelected(true);
        }
    }

    public AbstractButton addButton(String className) {
        WidgetDescriptor d = this.projectView.getProject().getTabWidgetDescriptor(className);
        d.setVisible(true);
        TabWidget widget = this.projectView.addTab(d);
        return this.addButton(widget);
    }

    private AbstractButton addButton(final TabWidget widget) {
        Icon icon = widget.getIcon();
        AbstractAction action = new AbstractAction(widget.getLabel(), icon){
            private static final long serialVersionUID = -6284395473725147927L;

            public void actionPerformed(ActionEvent event) {
                ViewSelector.this.projectView.setSelectedTab(widget);
            }
        };
        JToggleButton button = ComponentFactory.addToggleToolBarButton(this.toolBar, action);
        if (icon == null) {
            button.setText(widget.getLabel());
        }
        this.descriptorToButtonMap.put(widget.getDescriptor(), button);
        this.buttonGroup.add(button);
        button.setRolloverEnabled(false);
        button.setBorderPainted(true);
        this.toolBar.setRollover(false);
        return button;
    }

    private void setSelection(TabWidget widget) {
        this.combobox.removeItemListener(this.itemListener);
        this.combobox.setSelectedItem(widget.getDescriptor());
        this.combobox.addItemListener(this.itemListener);
        AbstractButton button = (AbstractButton)this.descriptorToButtonMap.get(widget.getDescriptor());
        if (button != null) {
            button.setSelected(true);
        }
    }
}

