/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WelcomeDialog
extends JDialog {
    private static final long serialVersionUID = 3986911949227734433L;
    JButton cancelButton;
    JButton faqButton;
    JButton newButton;
    JButton openOtherButton;
    JButton openRecentButton;
    JButton topicsButton;
    JButton tutorialButton;
    JButton usersGuideButton;
    JPanel helpButtonsPanel;
    JPanel projectsPanel;
    JLabel protegeIconLabel;
    List projectURIs;
    ProjectList projectList;

    public WelcomeDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.setSize(500, 300);
            this.projectURIs = new ArrayList(ApplicationProperties.getMRUProjectList());
            this.initializeUI();
        }
        catch (Exception ex) {
            Log.getLogger().severe(Log.toString(ex));
        }
    }

    private void initializeUI() {
        this.buildProjectsPanel();
        this.buildHelpPanel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.protegeIconLabel = new JLabel(Icons.getLogo());
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.insets = new Insets(7, 0, 0, 0);
        c.anchor = 10;
        contentPane.add((Component)this.protegeIconLabel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 2;
        c.fill = 1;
        c.insets = new Insets(7, 2, 0, 0);
        c.anchor = 23;
        c.weightx = 1.0;
        c.weighty = 1.0;
        contentPane.add((Component)this.projectsPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        contentPane.add((Component)this.helpButtonsPanel, c);
        this.cancelButton = WelcomeDialog.createButton(ResourceKey.CANCEL_BUTTON_LABEL, Icons.getCancelIcon());
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WelcomeDialog.this.closeButton_actionPerformed(e);
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 0;
        c.insets = new Insets(11, 0, 7, 0);
        c.anchor = 10;
        contentPane.add((Component)this.cancelButton, c);
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void buildProjectsPanel() {
        this.projectsPanel = new JPanel(new GridBagLayout());
        this.projectsPanel.setBorder(WelcomeDialog.createBorder(ResourceKey.WELCOME_DIALOG_OPEN_RECENT_PROJECT_TITLE));
        GridBagConstraints c = new GridBagConstraints();
        this.initializeList();
        JScrollPane projectScrollPane = new JScrollPane(this.projectList);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 4;
        c.fill = 1;
        c.insets = new Insets(0, 2, 5, 2);
        c.anchor = 23;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.projectsPanel.add((Component)projectScrollPane, c);
        this.openRecentButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_OPEN);
        this.openRecentButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_OPEN));
        WelcomeDialog.setToolTipText(this.openRecentButton, ResourceKey.WELCOME_DIALOG_OPEN_TOOLTIP);
        this.openRecentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.this.openButton_actionPerformed(ae);
            }
        });
        if (this.projectList.getModel().getSize() == 0) {
            this.openRecentButton.setEnabled(false);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.projectsPanel.add((Component)this.openRecentButton, c);
        this.openOtherButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_OPEN_OTHER, Icons.getOpenProjectIcon());
        this.openOtherButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_OPEN_OTHER));
        WelcomeDialog.setToolTipText(this.openOtherButton, ResourceKey.WELCOME_DIALOG_OPEN_OTHER_TOOLTIP);
        this.openOtherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.this.openOtherButton_actionPerformed(ae);
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        this.projectsPanel.add((Component)this.openOtherButton, c);
        JLabel label = new JLabel("");
        c.gridx = 1;
        c.gridy = 2;
        c.weighty = 1.0;
        this.projectsPanel.add((Component)label, c);
        this.newButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_NEW, Icons.getNewProjectIcon());
        this.newButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_NEW));
        WelcomeDialog.setToolTipText(this.newButton, ResourceKey.WELCOME_DIALOG_NEW_TOOLTIP);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.this.newButton_actionPerformed(ae);
            }
        });
        c.gridx = 1;
        c.gridy = 3;
        c.weighty = 0.0;
        this.projectsPanel.add((Component)this.newButton, c);
    }

    private void buildHelpPanel() {
        this.helpButtonsPanel = new JPanel();
        this.helpButtonsPanel.setLayout(new BoxLayout(this.helpButtonsPanel, 3));
        this.helpButtonsPanel.setBorder(WelcomeDialog.createBorder(ResourceKey.WELCOME_DIALOG_HELP_TITLE));
        Dimension verticalSpace = new Dimension(0, 5);
        this.tutorialButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_GETTING_STARTED);
        this.tutorialButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_GETTING_STARTED));
        this.tutorialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.tutorialButton_actionPerformed(ae);
            }
        });
        this.helpButtonsPanel.add(this.tutorialButton);
        this.helpButtonsPanel.add(Box.createRigidArea(verticalSpace));
        this.faqButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_FAQ);
        this.faqButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_FAQ));
        this.faqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.faqButton_actionPerformed(ae);
            }
        });
        this.helpButtonsPanel.add(this.faqButton);
        this.helpButtonsPanel.add(Box.createRigidArea(verticalSpace));
        this.usersGuideButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_USERS_GUIDE);
        this.usersGuideButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_USERS_GUIDE));
        this.usersGuideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.usersGuideButton_actionPerformed(ae);
            }
        });
        this.helpButtonsPanel.add(this.usersGuideButton);
        this.helpButtonsPanel.add(Box.createRigidArea(verticalSpace));
        this.topicsButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_ALL_TOPICS);
        this.topicsButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_ALL_TOPICS));
        this.topicsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WelcomeDialog.topicsButton_actionPerformed(ae);
            }
        });
        this.helpButtonsPanel.add(this.topicsButton);
        this.equalizeHelpButtons();
    }

    private static JButton createButton(ResourceKey key) {
        return new JButton(LocalizedText.getText(key));
    }

    private static JButton createButton(ResourceKey key, Icon icon) {
        return new JButton(LocalizedText.getText(key), icon);
    }

    private static TitledBorder createBorder(ResourceKey key) {
        String text = LocalizedText.getText(key);
        return new TitledBorder(BorderFactory.createEtchedBorder(), text);
    }

    private static void setToolTipText(AbstractButton button, ResourceKey key) {
        String text = LocalizedText.getText(key);
        button.setToolTipText(text);
    }

    private void initializeList() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (int i = 0; i < this.projectURIs.size(); ++i) {
            URI uri = (URI)this.projectURIs.get(i);
            String projectName = URIUtilities.getName(uri);
            model.addElement(projectName);
        }
        this.projectList = new ProjectList(model);
        this.projectList.setSelectionMode(0);
        if (this.projectList.getModel().getSize() != 0) {
            this.projectList.setSelectedIndex(0);
        }
        this.projectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.projectList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = WelcomeDialog.this.projectList.locationToIndex(e.getPoint());
                    WelcomeDialog.this.doOpenProject(index);
                }
            }
        });
    }

    private void doOpenProject(int index) {
        if (index >= 0) {
            URI uri = (URI)this.projectURIs.get(index);
            WaitCursor cursor = new WaitCursor(this.getRootPane());
            this.setVisible(false);
            ProjectManager.getProjectManager().loadProject(uri);
            ApplicationProperties.addProjectToMRUList(uri);
            cursor.hide();
        }
    }

    public void newButton_actionPerformed(ActionEvent ae) {
        boolean succeeded = ProjectManager.getProjectManager().createNewProjectRequest();
        if (succeeded) {
            this.setVisible(false);
        }
    }

    public void openButton_actionPerformed(ActionEvent ae) {
        int index = this.projectList.getSelectedIndex();
        this.doOpenProject(index);
    }

    public void openOtherButton_actionPerformed(ActionEvent ae) {
        boolean opened = ProjectManager.getProjectManager().openProjectRequest(this);
        if (opened) {
            this.setVisible(false);
        }
    }

    private static void faqButton_actionPerformed(ActionEvent ae) {
        SystemUtilities.showHTML(ApplicationProperties.getFAQURLString());
    }

    private static void topicsButton_actionPerformed(ActionEvent ae) {
        SystemUtilities.showHTML(ApplicationProperties.getAllHelpURLString());
    }

    private static void tutorialButton_actionPerformed(ActionEvent ae) {
        SystemUtilities.showHTML(ApplicationProperties.getGettingStartedURLString());
    }

    private static void usersGuideButton_actionPerformed(ActionEvent ae) {
        SystemUtilities.showHTML(ApplicationProperties.getUsersGuideURLString());
    }

    public void closeButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void equalizeHelpButtons() {
        String[] labels = new String[]{this.faqButton.getText(), this.topicsButton.getText(), this.tutorialButton.getText(), this.usersGuideButton.getText()};
        Dimension maxSize = new Dimension(0, 0);
        Rectangle2D textBounds = null;
        FontMetrics metrics = this.faqButton.getFontMetrics(this.faqButton.getFont());
        Graphics g = this.getGraphics();
        for (int i = 0; i < labels.length; ++i) {
            textBounds = metrics.getStringBounds(labels[i], g);
            maxSize.width = Math.max(maxSize.width, (int)textBounds.getWidth());
            maxSize.height = Math.max(maxSize.height, (int)textBounds.getHeight());
        }
        Insets insets = this.faqButton.getBorder().getBorderInsets(this.faqButton);
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        this.faqButton.setPreferredSize((Dimension)maxSize.clone());
        this.topicsButton.setPreferredSize((Dimension)maxSize.clone());
        this.tutorialButton.setPreferredSize((Dimension)maxSize.clone());
        this.usersGuideButton.setPreferredSize((Dimension)maxSize.clone());
        this.faqButton.setMaximumSize((Dimension)maxSize.clone());
        this.topicsButton.setMaximumSize((Dimension)maxSize.clone());
        this.tutorialButton.setMaximumSize((Dimension)maxSize.clone());
        this.usersGuideButton.setMaximumSize((Dimension)maxSize.clone());
    }

    private class ProjectList
    extends JList {
        private static final long serialVersionUID = 8193202451714386857L;

        ProjectList(DefaultListModel model) {
            this.setModel(model);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public String getToolTipText(MouseEvent event) {
            String toolTip = null;
            int index = this.locationToIndex(event.getPoint());
            if (index >= 0) {
                toolTip = WelcomeDialog.this.projectURIs.get(index).toString();
            }
            return toolTip;
        }
    }
}

