/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.event.Event;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.SessionEvent;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Serializable;
import java.util.Collection;

public abstract class AbstractEvent
extends SessionEvent
implements Localizable,
Event {
    private static final long serialVersionUID = -8345363395859512986L;
    private int _eventType;
    private Object _source;
    private Object _argument1;
    private Object _argument2;
    private Object _argument3;
    private long _timeStamp;
    private String _userName;
    private boolean replacementEvent = false;

    protected AbstractEvent(Object source, int type) {
        this(source, type, null, null, null);
    }

    protected AbstractEvent(Object source, int type, Object arg1) {
        this(source, type, arg1, null, null);
    }

    protected AbstractEvent(Object source, int type, Object arg1, Object arg2) {
        this(source, type, arg1, arg2, null);
    }

    protected AbstractEvent(Object source, int type, Object arg1, Object arg2, Object arg3) {
        super(source);
        if (source instanceof Serializable) {
            this._source = source;
        }
        this._eventType = type;
        this._argument1 = arg1;
        this._argument2 = arg2;
        this._argument3 = arg3;
        this._timeStamp = System.currentTimeMillis();
        this._userName = this.getUserName();
    }

    public void localize(KnowledgeBase kb) {
        LocalizeUtils.localize(this._source, kb);
        LocalizeUtils.localize(this._argument1, kb);
        LocalizeUtils.localize(this._argument2, kb);
        LocalizeUtils.localize(this._argument3, kb);
    }

    protected void setSource(Object o) {
        this._source = o;
        this.source = o;
    }

    public Object getArgument() {
        return this.getArgument1();
    }

    public Object getArgument1() {
        return this._argument1;
    }

    public Object getArgument2() {
        return this._argument2;
    }

    public Object getArgument3() {
        return this._argument3;
    }

    public int getEventType() {
        return this._eventType;
    }

    public Object getSource() {
        return this._source == null ? super.getSource() : this._source;
    }

    public String toString() {
        String text = StringUtilities.getClassName(this);
        return text + "(" + this.getSource() + ", " + this._eventType + ", " + this.getArgument1() + ", " + this.getArgument2() + ", " + this.getUserName() + ", " + this.getTimeStamp() + ")";
    }

    public int hashCode() {
        return HashUtils.getHash(this.source, this._argument1, this._argument2);
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof AbstractEvent) {
            AbstractEvent rhs = (AbstractEvent)o;
            equals = this._timeStamp == rhs._timeStamp && this._userName.equals(rhs._userName) && AbstractEvent.equals(this.source, rhs.source) && AbstractEvent.equals(this._argument1, rhs._argument1) && AbstractEvent.equals(this._argument2, rhs._argument2) && AbstractEvent.equals(this._argument3, rhs._argument3);
        }
        return equals;
    }

    public static boolean equals(Object o1, Object o2) {
        boolean equals = o1 instanceof Collection && o2 instanceof Collection ? CollectionUtilities.equalsSet((Collection)o1, (Collection)o2) : SystemUtilities.equals(o1, o2);
        return equals;
    }

    public void setTimeStamp(long timeStamp) {
        this._timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public String getUserName() {
        if (this._userName != null) {
            return this._userName;
        }
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this._userName = session != null ? session.getUserName() : ApplicationProperties.getUserName();
        return this._userName;
    }

    public boolean isReplacementEvent() {
        return this.replacementEvent;
    }

    public void setReplacementEvent(boolean replacementEvent) {
        this.replacementEvent = replacementEvent;
    }
}

