/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.StandardDateFormat;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractFormatter
extends Formatter {
    private static final String lineSeparator = SystemUtilities.getLineSeparator();
    private static final DateFormat dateFormat = new StandardDateFormat();

    protected String format(LogRecord record, String user, boolean showDate, boolean showMethod) {
        return this.format(record, user, showDate, showMethod, true, true);
    }

    protected String format(LogRecord record, String user, boolean showDate, boolean showMethod, boolean printLineSeparator, boolean showLevel) {
        StringBuffer buffer = new StringBuffer();
        if (showDate) {
            buffer.append(AbstractFormatter.getDateString());
            buffer.append(" ");
        }
        if (user != null) {
            buffer.append(user);
            buffer.append(" ");
        }
        if (showLevel) {
            Level level = record.getLevel();
            buffer.append(level.toString());
            buffer.append(": ");
        }
        buffer.append(record.getMessage());
        Throwable throwable = record.getThrown();
        if (throwable == null) {
            String className = record.getSourceClassName();
            if (showMethod && className != null) {
                buffer.append(" -- ");
                buffer.append(StringUtilities.getShortClassName(className));
                buffer.append(".");
                buffer.append(record.getSourceMethodName());
                buffer.append("(");
                Object[] arguments = record.getParameters();
                if (arguments != null) {
                    for (int i = 0; i < arguments.length; ++i) {
                        if (i != 0) {
                            buffer.append(", ");
                        }
                        buffer.append(AbstractFormatter.toString(arguments[i]));
                    }
                }
                buffer.append(")");
            }
        } else {
            buffer.append(" -- ");
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            buffer.append(writer.getBuffer());
        }
        if (printLineSeparator) {
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    protected static String getLineSeparator() {
        return lineSeparator;
    }

    protected static String getDateString() {
        return dateFormat.format(new Date());
    }

    protected static String toString(Object o) {
        String string;
        try {
            string = o == null ? null : (o instanceof Collection ? "[" + CollectionUtilities.toString((Collection)o) + "]" : (o.getClass().isArray() ? "{" + CollectionUtilities.toString(Arrays.asList((Object[])o)) + "}" : (o instanceof Frame ? ((Frame)o).getBrowserText() : o.toString())));
        }
        catch (Exception e) {
            string = "<<toString() exception>>";
        }
        return string;
    }
}

