/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StandardAction;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public abstract class AllowableAction
extends StandardAction {
    private static final long serialVersionUID = -1716212683037736161L;
    private Selectable _selectable;
    private boolean _isAllowed = true;

    protected AllowableAction(ResourceKey key) {
        super(key);
    }

    protected AllowableAction(ResourceKey key, Selectable selectable) {
        super(key);
        this.initializeSelectable(selectable);
    }

    protected AllowableAction(String name, Selectable selectable) {
        this(name, name, null, selectable);
    }

    protected AllowableAction(String name, Icon icon, Selectable selectable) {
        this(name, name, icon, selectable);
    }

    protected AllowableAction(String name, String description, Icon icon, Selectable selectable) {
        super(name, icon);
        this.putValue("ShortDescription", description);
        this.initializeSelectable(selectable);
    }

    private void initializeSelectable(Selectable selectable) {
        this._selectable = selectable;
        if (this._selectable != null) {
            this._selectable.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent event) {
                    AllowableAction.this.onSelectionChange();
                    AllowableAction.this.updateEnabledFlag();
                }
            });
            this.setEnabled(false);
        }
    }

    public Selectable getSelectable() {
        return this._selectable;
    }

    public Collection getSelection() {
        return this._selectable == null ? Collections.EMPTY_LIST : this._selectable.getSelection();
    }

    private boolean hasSelection() {
        return this._selectable != null && !this.getSelection().isEmpty();
    }

    public void onSelectionChange() {
    }

    public void setAllowed(boolean b) {
        this._isAllowed = b;
        this.updateEnabledFlag();
    }

    public boolean isAllowed() {
        return this._isAllowed;
    }

    private void updateEnabledFlag() {
        this.setEnabled(this._isAllowed && (this._selectable == null || this.hasSelection()));
    }
}

