/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class ApplicationProperties {
    public static final String FILE_NAME = "protege.properties";
    public static final String NEXT_FRAME_NUMBER = "next_frame_number";
    public static final String APPLICATION_INSTALL_DIRECTORY = "protege.dir";
    public static final String LAST_FILE_DIRECTORY = "filechooser.last_directory";
    public static final String LAST_LOADED_URI = "projectchooser.last_uri";
    public static final String CURRENT_WORKING_DIRECTORY = "user.dir";
    public static final String USERS_HOME_DIRECTORY = "user.home";
    public static final String PROPERTIES_IN_USER_HOME = "protege.properties.in.user.home";
    public static final String EXTRA_MANIFEST_PATH = "protege.plugin.manifest";
    public static final String MRU_PROJECTS = "history.projects.reopen";
    public static final String WELCOME_DIALOG = "ui.welcomedialog.show";
    public static final String WELCOME_DIALOG_START_IN_SERVER_PANEL = "ui.welcomedialog.start.in.server.panel";
    public static final String MAIN_FRAME_RECTANGLE = "mainframe.rectangle";
    public static final String LOOK_AND_FEEL = "swing.defaultlaf";
    public static final String BROWSER = "browser.html";
    private static final String AUTOSYNCHRONIZE_PROPERTY = "trees.autosynchronize";
    private static final String PRETTY_PRINT_SLOT_WIDGET_LABELS = "labels.pretty_print";
    public static final String LOG_FILE_PROPERTY = "java.util.logging.config.file";
    public static final String LOG_DEBUG_PROPERTY = "log.config.debug";
    public static final String REMOTE_CLIENT_PRELOAD = "remote.client.preload";
    public static final String URL_CONNECT_TIMEOUT = "url.connect.timeout";
    public static final String URL_CONNECT_READ_TIMEOUT = "url.connect.read.timeout";
    public static final String SORT_CLASS_TREE = "ui.sort.class.tree";
    public static final String SORT_SLOTS_TREE = "ui.sort.slot.tree";
    private static final Properties PROPERTIES = new Properties();
    private static File _propertyFile;
    private static final int num_MRUProjects = 10;
    private static List _mruProjectList;

    public static void setLookAndFeel(String lookAndFeelName) {
        ApplicationProperties.setProperty(LOOK_AND_FEEL, lookAndFeelName);
    }

    public static String getLookAndFeelClassName() {
        String name = ApplicationProperties.getApplicationOrSystemProperty(LOOK_AND_FEEL);
        if (name == null) {
            name = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
        }
        return name;
    }

    private static void loadMRUProjectList() {
        String projectNames = PROPERTIES.getProperty(MRU_PROJECTS);
        if (projectNames != null) {
            StringTokenizer st = new StringTokenizer(projectNames, ",");
            for (int i = 0; i < 10 && st.hasMoreElements(); ++i) {
                String projectString = (String)st.nextElement();
                URI uri = URIUtilities.createURI(projectString);
                try {
                    File file = new File(uri);
                    if (!file.exists()) continue;
                    _mruProjectList.add(uri);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    if (uri.getScheme().equals("rmi")) continue;
                    _mruProjectList.add(uri);
                }
            }
        } else {
            URI uri;
            String exampleProjectName;
            char sep = File.separatorChar;
            if (PluginUtilities.isPluginAvailable("edu.stanford.smi.protege.collab.projectPlugin.ProtegeCollabGUIProjectPlugin")) {
                exampleProjectName = ApplicationProperties.getApplicationDirectory().getPath() + sep + "examples" + sep + "collaborativePizza" + sep + "collaborativePizza.owl.pprj";
                uri = URIUtilities.createURI(exampleProjectName);
                ApplicationProperties.addProjectToMRUList(uri);
            }
            if (PluginUtilities.isOWLAvailable()) {
                exampleProjectName = ApplicationProperties.getApplicationDirectory().getPath() + sep + "examples" + sep + "pizza" + sep + "pizza.owl.pprj";
                uri = URIUtilities.createURI(exampleProjectName);
                ApplicationProperties.addProjectToMRUList(uri);
                exampleProjectName = ApplicationProperties.getApplicationDirectory().getPath() + sep + "examples" + sep + "sqwrl" + sep + "SQWRLCollectionExamples.pprj";
                uri = URIUtilities.createURI(exampleProjectName);
                ApplicationProperties.addProjectToMRUList(uri);
                exampleProjectName = ApplicationProperties.getApplicationDirectory().getPath() + sep + "examples" + sep + "sqwrl" + sep + "SQWRLCoreExamples.pprj";
                uri = URIUtilities.createURI(exampleProjectName);
                ApplicationProperties.addProjectToMRUList(uri);
            }
            exampleProjectName = ApplicationProperties.getApplicationDirectory().getPath() + sep + "examples" + sep + "newspaper" + sep + "newspaper.pprj";
            uri = URIUtilities.createURI(exampleProjectName);
            ApplicationProperties.addProjectToMRUList(uri);
        }
    }

    public static void addProjectToMRUList(URI uri) {
        if (uri != null && !uri.getScheme().equals("rmi")) {
            uri = URIUtilities.normalize(uri);
            _mruProjectList.remove(uri);
            _mruProjectList.add(0, uri);
            if (_mruProjectList.size() > 10) {
                _mruProjectList.remove(10);
            }
            ApplicationProperties.saveMRUProjectList();
        }
    }

    public static void flush() {
        try {
            if (_propertyFile != null) {
                FileOutputStream os = new FileOutputStream(_propertyFile);
                PROPERTIES.store(os, "Protege Properties");
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            Log.getLogger().warning(e.toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static File getPropertiesDirectory() {
        String s;
        boolean useUserHome = Boolean.getBoolean(PROPERTIES_IN_USER_HOME);
        File dir = useUserHome ? ((s = SystemUtilities.getSystemProperty(USERS_HOME_DIRECTORY)) == null ? null : new File(s)) : ApplicationProperties.getApplicationDirectory();
        return dir;
    }

    public static File getLogFileDirectory() {
        File file = ApplicationProperties.getPropertiesDirectory();
        if (file != null) {
            file = new File(file, "logs");
            file.mkdir();
        }
        return file;
    }

    public static File getApplicationDirectory() {
        String dir = SystemUtilities.getSystemProperty(APPLICATION_INSTALL_DIRECTORY);
        if (dir == null) {
            dir = SystemUtilities.getSystemProperty(CURRENT_WORKING_DIRECTORY);
        }
        return dir == null ? null : new File(dir);
    }

    public static String getExtraManifestPath() {
        String s = SystemUtilities.getSystemProperty(EXTRA_MANIFEST_PATH);
        if (s != null && s.length() > 1 && s.charAt(0) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static int getIntegerProperty(String name, int defaultValue) {
        int value = defaultValue;
        String propString = PROPERTIES.getProperty(name);
        if (propString != null) {
            try {
                value = Integer.parseInt(propString);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return value;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean value = defaultValue;
        String propString = PROPERTIES.getProperty(name);
        if (propString != null) {
            try {
                value = Boolean.valueOf(propString);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return value;
    }

    public static List getMRUProjectList() {
        return new ArrayList(_mruProjectList);
    }

    public static int getOldNextFrameNumber() {
        String nextInstanceString = PROPERTIES.getProperty(NEXT_FRAME_NUMBER, "0");
        int nextInstance = Integer.parseInt(nextInstanceString);
        return nextInstance;
    }

    public static String getBrowser() {
        String property = PROPERTIES.getProperty(BROWSER);
        if (property != null && property.length() == 0) {
            property = null;
        }
        return property;
    }

    private static Rectangle getRectangle(String name) {
        Rectangle rectangle = null;
        String property = PROPERTIES.getProperty(name);
        if (property != null) {
            rectangle = ApplicationProperties.parseRectangle(property);
        }
        return rectangle;
    }

    public static Properties getApplicationProperties() {
        return PROPERTIES;
    }

    public static String getApplicationOrSystemProperty(String name) {
        return ApplicationProperties.getApplicationOrSystemProperty(name, null);
    }

    public static String getApplicationOrSystemProperty(String name, String defaultValue) {
        String value = PROPERTIES.getProperty(name);
        if (value == null) {
            try {
                value = System.getProperty(name);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getString(String name) {
        return ApplicationProperties.getString(name, null);
    }

    public static String getString(String name, String defaultValue) {
        return PROPERTIES.getProperty(name, defaultValue);
    }

    private static Rectangle parseRectangle(String text) {
        int[] numbers = new int[4];
        StringTokenizer st = new StringTokenizer(text);
        for (int index = 0; st.hasMoreTokens() && index < numbers.length; ++index) {
            String token = st.nextToken();
            numbers[index] = Integer.parseInt(token);
        }
        return new Rectangle(numbers[0], numbers[1], numbers[2], numbers[3]);
    }

    public static void recordMainFrameProperties(Frame mainFrame) {
        ApplicationProperties.saveRectangle(MAIN_FRAME_RECTANGLE, mainFrame.getBounds());
    }

    public static void restoreMainFrameProperties(Frame mainFrame) {
        Rectangle r = ApplicationProperties.getRectangle(MAIN_FRAME_RECTANGLE);
        if (r == null) {
            mainFrame.setSize(ComponentUtilities.getDefaultMainFrameSize());
            ComponentUtilities.center(mainFrame);
        } else {
            mainFrame.setBounds(r);
        }
    }

    private static void saveMRUProjectList() {
        StringBuffer buf = new StringBuffer();
        int size = _mruProjectList.size();
        for (int i = 0; i < size; ++i) {
            buf.append(_mruProjectList.get(i));
            buf.append(",");
        }
        buf.setLength(buf.length() - 1);
        ApplicationProperties.setProperty(MRU_PROJECTS, buf.toString());
    }

    private static void setProperty(String property, String value) {
        try {
            if (value == null) {
                PROPERTIES.remove(property);
            } else {
                PROPERTIES.setProperty(property, value);
            }
            ApplicationProperties.flush();
        }
        catch (Exception e) {
            Log.getLogger().warning(Log.toString(e));
        }
    }

    private static void saveRectangle(String name, Rectangle r) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(r.x));
        buffer.append(" ");
        buffer.append(String.valueOf(r.y));
        buffer.append(" ");
        buffer.append(String.valueOf(r.width));
        buffer.append(" ");
        buffer.append(String.valueOf(r.height));
        ApplicationProperties.setProperty(name, buffer.toString());
    }

    public static void setInt(String name, int value) {
        ApplicationProperties.setProperty(name, String.valueOf(value));
    }

    public static void setBoolean(String name, boolean value) {
        ApplicationProperties.setProperty(name, String.valueOf(value));
    }

    public static void setString(String name, String value) {
        ApplicationProperties.setProperty(name, value);
    }

    public static boolean getWelcomeDialogShow() {
        String s = ApplicationProperties.getString(WELCOME_DIALOG, "true");
        return s.equalsIgnoreCase("true");
    }

    public static void setUserName(String name) {
        ApplicationProperties.setProperty("user.name", name);
    }

    public static void setWelcomeDialogShow(boolean b) {
        ApplicationProperties.setBoolean(WELCOME_DIALOG, b);
    }

    public static boolean isAutosynchronizingClsTrees() {
        return ApplicationProperties.getBooleanProperty(AUTOSYNCHRONIZE_PROPERTY, true);
    }

    public static void setAutosynchronizingClsTrees(boolean b) {
        ApplicationProperties.setBoolean(AUTOSYNCHRONIZE_PROPERTY, b);
    }

    public static String getGettingStartedURLString() {
        return "http://protege.stanford.edu/doc/tutorial/get_started/table_of_content.html";
    }

    public static String getFAQURLString() {
        return "http://protege.stanford.edu/doc/faq.html";
    }

    public static String getUsersGuideURLString() {
        return "http://protegewiki.stanford.edu/index.php/PrF_UG";
    }

    public static String getAllHelpURLString() {
        return "http://protege.stanford.edu/doc/users.html";
    }

    public static String getOntology101URLString() {
        return "http://protege.stanford.edu/publications/ontology_development/ontology101.html";
    }

    public static String getHowToCiteProtegeURLString() {
        return "http://protegewiki.stanford.edu/wiki/HowToCiteProtege";
    }

    public static String getUserName() {
        return ApplicationProperties.getApplicationOrSystemProperty("user.name");
    }

    public static Locale getLocale() {
        String language = ApplicationProperties.getApplicationOrSystemProperty("user.language");
        String country = ApplicationProperties.getApplicationOrSystemProperty("user.country");
        return new Locale(language, country);
    }

    public static void setLocale(Locale locale) {
        ApplicationProperties.setProperty("user.language", locale.getLanguage());
        ApplicationProperties.setProperty("user.country", locale.getCountry());
    }

    public static boolean getPrettyPrintSlotWidgetLabels() {
        return ApplicationProperties.getBooleanProperty(PRETTY_PRINT_SLOT_WIDGET_LABELS, true);
    }

    public static void setPrettyPrintSlotWidgetLabels(boolean b) {
        ApplicationProperties.setBoolean(PRETTY_PRINT_SLOT_WIDGET_LABELS, b);
    }

    public static File getLastFileDirectory() {
        String directory = ApplicationProperties.getString(LAST_FILE_DIRECTORY);
        if (directory == null) {
            directory = ApplicationProperties.getApplicationOrSystemProperty(USERS_HOME_DIRECTORY);
        }
        return new File(directory);
    }

    public static void setLastFileDirectory(File directory) {
        ApplicationProperties.setString(LAST_FILE_DIRECTORY, directory.getPath());
    }

    public static URI getLastLoadeURI() {
        URI uri = null;
        String uriString = ApplicationProperties.getString(LAST_LOADED_URI);
        if (uriString != null) {
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    public static void setLastLoadedURI(URI uri) {
        ApplicationProperties.setString(LAST_LOADED_URI, uri.toString());
    }

    public static int getUrlConnectTimeout() {
        int timeout = 15;
        String timeoutString = ApplicationProperties.getApplicationOrSystemProperty(URL_CONNECT_TIMEOUT, "15");
        try {
            timeout = Integer.parseInt(timeoutString);
        }
        catch (NumberFormatException e) {
            Log.getLogger().warning("Error parsing " + timeoutString + " to an int. Cannot set URL connect timeout. Use default value (15 sec).");
        }
        return timeout;
    }

    public static void setUrlConnectTimeout(int timeout) {
        ApplicationProperties.setInt(URL_CONNECT_TIMEOUT, timeout);
    }

    public static int getUrlConnectReadTimeout() {
        int timeout = 15;
        String timeoutString = ApplicationProperties.getApplicationOrSystemProperty(URL_CONNECT_READ_TIMEOUT, "15");
        try {
            timeout = Integer.parseInt(timeoutString);
        }
        catch (NumberFormatException e) {
            Log.getLogger().warning("Error parsing " + timeoutString + " to an int. Cannot set URL read connect timeout. Use default value (15 sec).");
        }
        return timeout;
    }

    public static void setUrlConnectReadTimeout(int timeout) {
        ApplicationProperties.setInt(URL_CONNECT_READ_TIMEOUT, timeout);
    }

    public static void setSortClassTreeOption(boolean classTreeSorted) {
        ApplicationProperties.setBoolean(SORT_CLASS_TREE, classTreeSorted);
    }

    public static void setSortSlotTreeOption(boolean propertiesTreeSorted) {
        ApplicationProperties.setBoolean(SORT_SLOTS_TREE, propertiesTreeSorted);
    }

    public static boolean getSortClassTreeOption() {
        return ApplicationProperties.getBooleanProperty(SORT_CLASS_TREE, true);
    }

    public static boolean getSortSlotTreeOption() {
        return ApplicationProperties.getBooleanProperty(SORT_SLOTS_TREE, true);
    }

    static {
        _mruProjectList = new ArrayList(10);
        try {
            _propertyFile = new File(ApplicationProperties.getPropertiesDirectory(), FILE_NAME);
            FileInputStream is = new FileInputStream(_propertyFile);
            PROPERTIES.load(is);
            ((InputStream)is).close();
            ApplicationProperties.loadMRUProjectList();
        }
        catch (IOException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

