/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;

public class ArchiveManager {
    private static final ArchiveManager THE_INSTANCE = new ArchiveManager();
    private static final DateFormat THE_FORMAT = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss");
    private static final String TMP_TABLE_NAME = "prtgeTmp";
    private int tableNameIndex = 0;

    public static ArchiveManager getArchiveManager() {
        return THE_INSTANCE;
    }

    public static DateFormat getDateFormat() {
        return THE_FORMAT;
    }

    private ArchiveManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive(Project p, String comment) {
        String name = p.getProjectName();
        File projectDir = ArchiveManager.getProjectDirectoryFile(p);
        File archiveDir = ArchiveManager.createArchiveDir(name, projectDir, new Date());
        File tempDir = ArchiveManager.getEmptyTempDir(name, archiveDir);
        ArchiveManager.moveProject(name, projectDir, tempDir);
        try {
            ArrayList errors = new ArrayList();
            this.saveProject(p, errors);
            this.logErrors(errors);
            ArchiveManager.moveProject(name, projectDir, archiveDir);
            ArchiveManager.createComment(archiveDir, comment);
        }
        finally {
            ArchiveManager.moveProject(name, tempDir, projectDir);
            tempDir.delete();
        }
    }

    private void saveProject(Project prj, Collection errors) {
        if (prj.getKnowledgeBaseFactory() instanceof DatabaseKnowledgeBaseFactory) {
            String origTableName = DatabaseKnowledgeBaseFactory.getTableName(prj.getSources());
            String newTableName = "ProtegeTable";
            Connection connection = null;
            try {
                connection = ArchiveManager.getDBConnection(prj);
                newTableName = this.getNextTableNameIndex(connection, origTableName);
                connection.close();
            }
            catch (SQLException e) {
                errors.add(e);
                throw new RuntimeException("Archive error", e);
            }
            this.copyDBProjectInNewTable(prj, errors, newTableName);
        } else {
            prj.save(errors);
        }
    }

    private void copyDBProjectInNewTable(Project prj, Collection errors, String newTableName) {
        String origTableName = DatabaseKnowledgeBaseFactory.getTableName(prj.getSources());
        DatabaseKnowledgeBaseFactory.setTablename(prj.getSources(), newTableName);
        try {
            prj.save(errors);
        }
        catch (Exception e) {
            errors.add(e);
            throw new RuntimeException(e);
        }
        finally {
            DatabaseKnowledgeBaseFactory.setTablename(prj.getSources(), origTableName);
        }
    }

    private static File getProjectDirectoryFile(Project p) {
        URI uri = p.getProjectURI();
        return uri == null ? null : new File(uri).getParentFile();
    }

    private static File createArchiveDir(String name, File projectDir, Date date) {
        File archiveDir = ArchiveManager.getArchiveDir(name, projectDir, date);
        archiveDir.mkdirs();
        return archiveDir;
    }

    private static File getArchiveDir(String name, File projectDir, Date date) {
        File mainArchiveDir = ArchiveManager.getMainArchiveDir(name, projectDir);
        return new File(mainArchiveDir, ArchiveManager.getTimestamp(date));
    }

    private static File getMainArchiveDir(String name, File projectDir) {
        File mainArchiveDir = new File(projectDir, name + ".parc");
        mainArchiveDir.mkdir();
        return mainArchiveDir;
    }

    private static void moveProject(String projectName, File sourceDir, File targetDir) {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String sourceFileName;
                File sourceFile = files[i];
                if (!sourceFile.isFile() || !(sourceFileName = sourceFile.getName()).startsWith(projectName)) continue;
                File targetFile = new File(targetDir, sourceFileName);
                sourceFile.renameTo(targetFile);
            }
        }
    }

    private static void copyProject(String projectName, File sourceDir, File targetDir) {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String sourceFileName;
                File sourceFile = files[i];
                if (!sourceFile.isFile() || !(sourceFileName = sourceFile.getName()).startsWith(projectName)) continue;
                File targetFile = new File(targetDir, sourceFileName);
                ArchiveManager.copyFile(sourceFile, targetFile);
            }
        }
    }

    private static File getEmptyTempDir(String projectName, File archiveDir) {
        File[] files;
        File tempDir = new File(archiveDir, "temp");
        boolean created = tempDir.mkdir();
        if (!created && (files = tempDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        return tempDir;
    }

    public Collection getArchiveRecords(Project p) {
        ArrayList<ArchiveRecord> records = new ArrayList<ArchiveRecord>();
        File[] file = ArchiveManager.getMainArchiveDir(p.getProjectName(), ArchiveManager.getProjectDirectoryFile(p)).listFiles();
        for (int i = 0; i < file.length; ++i) {
            records.add(new ArchiveRecord(file[i], ArchiveManager.getComment(file[i])));
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project revertToVersion(Project p, Date date) {
        Project revertedProject = null;
        String name = p.getProjectName();
        File projectDir = ArchiveManager.getProjectDirectoryFile(p);
        File archiveDir = ArchiveManager.getArchiveDir(name, projectDir, date);
        File tempDir = ArchiveManager.getEmptyTempDir(name, archiveDir);
        ArrayList errors = new ArrayList();
        if (p.getKnowledgeBaseFactory() instanceof DatabaseKnowledgeBaseFactory) {
            revertedProject = this.revertToDBVersion(p, projectDir, archiveDir, tempDir, errors);
        } else {
            ArchiveManager.moveProject(name, projectDir, tempDir);
            ArchiveManager.moveProject(name, archiveDir, projectDir);
            try {
                revertedProject = Project.loadProjectFromURI(p.getProjectURI(), errors);
            }
            finally {
                ArchiveManager.moveProject(name, projectDir, archiveDir);
                ArchiveManager.moveProject(name, tempDir, projectDir);
                tempDir.delete();
            }
        }
        this.logErrors(errors);
        return revertedProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project revertToDBVersion(Project prj, File projectDir, File archiveDir, File tempDir, Collection errors) {
        Project revertedProject = null;
        String name = prj.getProjectName();
        String originalTableName = DatabaseKnowledgeBaseFactory.getTableName(prj.getSources());
        ArchiveManager.moveProject(name, projectDir, tempDir);
        try {
            ArchiveManager.renameTable(prj, originalTableName, TMP_TABLE_NAME);
        }
        catch (SQLException e) {
            errors.add(e);
            ArchiveManager.moveProject(name, tempDir, projectDir);
            return null;
        }
        ArchiveManager.copyProject(name + ".pprj", archiveDir, projectDir);
        try {
            revertedProject = this.loadAndMoveDBProject(prj, errors);
        }
        catch (Exception e) {
            errors.add(e);
            try {
                ArchiveManager.renameTable(prj, TMP_TABLE_NAME, originalTableName);
                ArchiveManager.moveProject(name, tempDir, projectDir);
            }
            catch (SQLException e1) {
                errors.add(e);
                Project project = null;
                return project;
            }
        }
        finally {
            ArchiveManager.moveProject(name, tempDir, projectDir);
            tempDir.delete();
        }
        return revertedProject;
    }

    private Project loadAndMoveDBProject(Project prj, Collection errors) {
        String originalTableName = DatabaseKnowledgeBaseFactory.getTableName(prj.getSources());
        Project revertedProject = null;
        try {
            revertedProject = Project.loadProjectFromURI(prj.getProjectURI(), errors);
        }
        catch (Exception e) {
            errors.add(e);
            throw new RuntimeException(e);
        }
        DatabaseKnowledgeBaseFactory.setTablename(revertedProject.getSources(), originalTableName);
        revertedProject.save(errors);
        revertedProject = Project.loadProjectFromURI(prj.getProjectURI(), errors);
        return revertedProject;
    }

    private static String getTimestamp(Date date) {
        return THE_FORMAT.format(date);
    }

    private static String getComment(File directory) {
        String comment = null;
        File file = ArchiveManager.getCommentFile(directory);
        if (file != null) {
            try {
                BufferedReader reader = FileUtilities.createBufferedReader(file);
                comment = reader.readLine();
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return comment;
    }

    private static File getCommentFile(File directory) {
        return new File(directory, "comment.txt");
    }

    private static void createComment(File directory, String comment) {
        if (comment != null && comment.length() > 0) {
            File file = ArchiveManager.getCommentFile(directory);
            try {
                PrintWriter pw = FileUtilities.createPrintWriter(file, false);
                pw.println(comment);
                pw.close();
            }
            catch (Exception e) {
                Log.getLogger().warning(e.toString());
            }
        }
    }

    private void logErrors(Collection errors) {
        if (errors == null || errors.size() == 0) {
            return;
        }
        Log.getLogger().severe("There were errors at archiving/reverting project");
        for (Object error : errors) {
            if (error instanceof Throwable) {
                Log.getLogger().log(Level.SEVERE, ((Throwable)error).getMessage(), error);
                continue;
            }
            if (error instanceof MessageError) {
                MessageError msgErr = (MessageError)error;
                Log.getLogger().log(Level.SEVERE, msgErr.getMessage(), msgErr.getException());
                continue;
            }
            Log.getLogger().severe(error.toString());
        }
    }

    private static void copyFile(File inputFile, File outputFile) {
        try {
            int c;
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            Log.getLogger().log(Level.WARNING, "Error at copying file " + inputFile + " to " + outputFile, e);
        }
        catch (IOException e) {
            Log.getLogger().log(Level.WARNING, "Error at copying file " + inputFile + " to " + outputFile, e);
        }
    }

    private static Connection getDBConnection(Project prj) throws SQLException {
        String url = DatabaseKnowledgeBaseFactory.getURL(prj.getSources());
        String userName = DatabaseKnowledgeBaseFactory.getUsername(prj.getSources());
        String password = DatabaseKnowledgeBaseFactory.getPassword(prj.getSources());
        Connection connection = null;
        connection = DriverManager.getConnection(url, userName, password);
        return connection;
    }

    private String getNextTableNameIndex(Connection connection, String origName) {
        String tableName = origName + Integer.toString(this.tableNameIndex);
        while (ArchiveManager.tableExists(connection, tableName)) {
            ++this.tableNameIndex;
            tableName = origName + Integer.toString(this.tableNameIndex);
        }
        return tableName;
    }

    private static boolean tableExists(Connection connection, String tableName) {
        boolean exists = false;
        try {
            Statement statement = connection.createStatement();
            String query = "SELECT COUNT(*) FROM " + tableName;
            ResultSet rs = statement.executeQuery(query);
            rs.close();
            statement.close();
            exists = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return exists;
    }

    private static void renameTable(Project prj, String tableName, String newTableName) throws SQLException {
        Connection connection = ArchiveManager.getDBConnection(prj);
        ArchiveManager.renameTable(connection, tableName, newTableName);
        connection.close();
    }

    private static void renameTable(Connection connection, String tableName, String newTableName) throws SQLException {
        boolean s;
        String query;
        Statement statement;
        try {
            statement = connection.createStatement();
            query = "DROP TABLE " + newTableName;
            s = statement.execute(query);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        statement = connection.createStatement();
        query = "RENAME TABLE " + tableName + " TO " + newTableName;
        s = statement.execute(query);
        statement.close();
    }

    private static void deleteTable(Project prj, String tableName) {
        try {
            Connection connection = ArchiveManager.getDBConnection(prj);
            Statement statement = connection.createStatement();
            String query = "DROP " + tableName;
            ResultSet rs = statement.executeQuery(query);
            rs.close();
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

