/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.action.ConvertUnicodeSequenceAction;
import edu.stanford.smi.protege.action.InsertUnicodeCharacterAction;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultListDragSourceListener;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.DoubleClickActionAdapter;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.ListTarget;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class ComponentFactory {
    public static final int STANDARD_BUTTON_HEIGHT = 25;
    public static final Dimension STANDARD_BUTTON_SIZE = new Dimension(25, 25);
    public static final int LARGE_BUTTON_HEIGHT = 33;
    public static final int STANDARD_FIELD_HEIGHT = 25;
    private static int _offset;
    private static final int OFFSET_SIZE = 25;
    private static final int MIN_LEFT_SPLIT_PANE_WIDTH;
    private static final String UNICODE_CHOOSER_CLASS = "com.catalysoft.swing.unicode.UnicodeChooser";

    private static int getMinLeftSplitPaneWidth() {
        String property = ComponentFactory.class.getName() + ".min_left_split_pane_width";
        String value = ApplicationProperties.getApplicationOrSystemProperty(property);
        int i = value == null ? 275 : Integer.parseInt(value);
        return i;
    }

    public static void addMenuItem(JMenu menu, final Action action) {
        JMenuItem item = new JMenuItem(action){
            private static final long serialVersionUID = 5987721943542141158L;

            public String getText() {
                String text = null;
                text = action == null ? super.getText() : (String)action.getValue("Name");
                return text;
            }

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }
        };
        menu.add(item);
        item.setDisabledIcon((Icon)action.getValue("SmallIcon"));
    }

    public static void addMenuItemNoIcon(JMenu menu, Action action) {
        ComponentFactory.addMenuItem(menu, action);
    }

    public static void addSubmenu(JMenu menu, JMenu submenu) {
        menu.add(submenu);
    }

    public static JToggleButton addToggleToolBarButton(JToolBar toolBar, Action action) {
        return ComponentFactory.addToggleToolBarButton(toolBar, action, 25);
    }

    public static JToggleButton addLargeToggleToolBarButton(JToolBar toolBar, Action action) {
        return ComponentFactory.addToggleToolBarButton(toolBar, action, 33);
    }

    public static JToggleButton addToggleToolBarButton(JToolBar toolBar, Action action, int width) {
        JToggleButton button = new JToggleButton(action);
        button.setToolTipText((String)action.getValue("Name"));
        ComponentFactory.addToolBarButton(toolBar, action, button);
        return button;
    }

    public static void addToolBarButton(JToolBar toolBar, Action action, AbstractButton button) {
        button.setText(null);
        toolBar.add(button);
    }

    public static JButton addToolBarButton(JToolBar bar, Action action) {
        return ComponentFactory.addToolBarButton(bar, action, 25);
    }

    public static JButton addLargeToolBarButton(JToolBar bar, Action action) {
        return ComponentFactory.addToolBarButton(bar, action, 33);
    }

    public static JButton addToolBarButton(JToolBar bar, Action action, int width) {
        JButton button = new JButton(action);
        ComponentFactory.addButton(bar, action, button, width);
        return button;
    }

    private static void addButton(JToolBar bar, Action action, AbstractButton button, int width) {
        button.setText(null);
        button.setToolTipText(StandardAction.getName(action));
        button.setOpaque(false);
        button.setRolloverEnabled(true);
        button.setMnemonic(0);
        action.putValue("protege.component", button);
        Dimension size = new Dimension();
        size.width = size.height = width;
        button.setSize(size);
        button.setPreferredSize(size);
        button.setMinimumSize(size);
        button.setMaximumSize(size);
        button.setDisabledIcon((Icon)action.getValue("DisabledSmallIcon"));
        if (button.getIcon() == null) {
            button.setIcon(Icons.getUglyIcon());
        }
        bar.add(button);
    }

    private static void adjustPosition(Component c) {
        _offset = (_offset + 1) % 4;
        Point p = c.getLocation();
        p.x += _offset * 25;
        p.y += _offset * 25;
        c.setLocation(p);
    }

    private static Dimension buttonPreferredHeightSize(Dimension d) {
        d.height = Math.max(25, d.height);
        return d;
    }

    private static int getHeight(Component c) {
        return c.getFontMetrics(c.getFont()).getHeight() + 4;
    }

    private static void configureList(JList list, Action action, boolean enableDragAndDrop) {
        list.setModel(new SimpleListModel());
        if (action != null) {
            list.addMouseListener(new DoubleClickActionAdapter(action));
        }
        if (enableDragAndDrop) {
            ComponentFactory.setupDragAndDrop(list);
            ComponentUtilities.setDragAndDropEnabled(list, enableDragAndDrop);
        }
        list.setCellRenderer(new DefaultRenderer());
        list.setFixedCellHeight(ComponentFactory.getHeight(list));
    }

    public static void configureTable(JTable table) {
        table.setRowHeight(ComponentFactory.getHeight(table));
    }

    public static void configureTree(JTree tree, Action action) {
        if (action != null) {
            tree.addMouseListener(new DoubleClickActionAdapter(action));
        }
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        tree.setRowHeight(ComponentFactory.getHeight(tree));
    }

    public static JButton createButton(Action action) {
        JButton button = new JButton(action);
        return button;
    }

    public static JCheckBox createCheckBox() {
        return ComponentFactory.createCheckBox("");
    }

    public static JCheckBox createCheckBox(String s) {
        JCheckBox checkBox = new JCheckBox(s){
            private static final long serialVersionUID = -4867160758865380345L;

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }
        };
        return checkBox;
    }

    public static JComboBox createComboBox() {
        JComboBox comboBox = new JComboBox(){
            private static final long serialVersionUID = 5278650003666881110L;

            public Dimension getPreferredSize() {
                return ComponentFactory.fieldPreferredHeightSize(super.getPreferredSize());
            }

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }
        };
        return comboBox;
    }

    public static JFileChooser createFileChooser(String description, String extension) {
        return ComponentFactory.createFileChooser(description, null, extension);
    }

    public static JFileChooser createFileChooser(String title, String fileDescription, String fileExtension) {
        File lastDirectory = ApplicationProperties.getLastFileDirectory();
        JFileChooser chooser = new JFileChooser(lastDirectory){
            private static final long serialVersionUID = -8638528742036901626L;

            public int showDialog(Component c, String s) {
                int rval = super.showDialog(c, s);
                if (rval == 0) {
                    ApplicationProperties.setLastFileDirectory(this.getCurrentDirectory());
                }
                return rval;
            }
        };
        chooser.setDialogTitle(title);
        if (fileExtension == null) {
            chooser.setFileSelectionMode(1);
        } else if (fileExtension.length() > 0) {
            String text = fileDescription;
            chooser.setFileFilter(new ExtensionFilter(fileExtension, text));
        }
        return chooser;
    }

    public static JFileChooser createFileChooser(String title, ExtensionFilter extensionFilter) {
        File lastDirectory = ApplicationProperties.getLastFileDirectory();
        JFileChooser chooser = new JFileChooser(lastDirectory){
            private static final long serialVersionUID = 3135157582164095101L;

            public int showDialog(Component c, String s) {
                int rval = super.showDialog(c, s);
                if (rval == 0) {
                    ApplicationProperties.setLastFileDirectory(this.getCurrentDirectory());
                }
                return rval;
            }
        };
        chooser.setDialogTitle(title);
        if (extensionFilter == null) {
            chooser.setFileSelectionMode(1);
        } else {
            chooser.setFileFilter(extensionFilter);
        }
        return chooser;
    }

    public static JFileChooser createSaveFileChooser(String title, String fileDescription, String fileExtension, final boolean overwrite) {
        File lastDirectory = ApplicationProperties.getLastFileDirectory();
        JFileChooser chooser = new JFileChooser(lastDirectory){
            private static final long serialVersionUID = 2958086335982181478L;

            public int showDialog(Component c, String s) {
                int rval = super.showDialog(c, s);
                if (rval == 0) {
                    ApplicationProperties.setLastFileDirectory(this.getCurrentDirectory());
                }
                return rval;
            }

            public void approveSelection() {
                String title;
                String msg;
                int option;
                if (!overwrite) {
                    return;
                }
                File f = this.getSelectedFile();
                if (f.exists() && (option = JOptionPane.showConfirmDialog(this, msg = "The file '" + f.getName() + "' already exists!\nDo you want to replace it?", title = this.getDialogTitle(), 0, 2)) == 1) {
                    return;
                }
                super.approveSelection();
            }
        };
        chooser.setDialogType(1);
        chooser.setDialogTitle(title);
        if (fileExtension != null) {
            String text = fileDescription;
            chooser.setFileFilter(new ExtensionFilter(fileExtension, text));
        }
        return chooser;
    }

    public static JFrame createMainFrame() {
        JFrame frame = new JFrame();
        ComponentFactory.initializeFrame(frame);
        return frame;
    }

    public static JFrame createFrame() {
        DisposableFrame frame = new DisposableFrame();
        ComponentFactory.initializeFrame(frame);
        return frame;
    }

    private static void initializeFrame(JFrame frame) {
        frame.setDefaultCloseOperation(0);
        Image logo = ((ImageIcon)Icons.getLogoIcon()).getImage();
        frame.setIconImage(logo);
    }

    public static JLabel createLabel() {
        JLabel label = new JLabel(){
            private static final long serialVersionUID = -7070554182697163025L;

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }
        };
        return label;
    }

    public static JLabel createLabel(String s) {
        JLabel label = ComponentFactory.createLabel();
        label.setText(s);
        return label;
    }

    public static JLabel createLabel(Icon icon) {
        JLabel label = ComponentFactory.createLabel();
        label.setIcon(icon);
        return label;
    }

    public static JLabel createLabel(Icon icon, int alignment) {
        JLabel label = ComponentFactory.createLabel(icon);
        label.setHorizontalAlignment(alignment);
        return label;
    }

    public static JLabel createLabel(String s, int alignment) {
        JLabel label = ComponentFactory.createLabel(s);
        label.setHorizontalAlignment(alignment);
        return label;
    }

    public static JLabel createLabel(String s, Icon icon, int alignment) {
        JLabel label = ComponentFactory.createLabel(icon, alignment);
        label.setText(s);
        return label;
    }

    public static LabeledComponent createLabeledScrollComponent(String label, JComponent basicComponent, Dimension preferredSize) {
        LabeledComponent component = new LabeledComponent(label, ComponentFactory.createScrollPane(basicComponent));
        if (preferredSize != null) {
            component.setPreferredSize(preferredSize);
        }
        return component;
    }

    public static LabeledComponent createLabeledScrollComponent(String label, JComponent basicComponent, Dimension preferredSize, JComponent headerComponent, Collection headerButtons, JComponent footerComponent) {
        LabeledComponent component = ComponentFactory.createLabeledScrollComponent(label, basicComponent, preferredSize);
        if (headerComponent != null) {
            component.setHeaderComponent(headerComponent);
        }
        if (headerButtons != null) {
            Iterator buttonList = headerButtons.iterator();
            while (buttonList.hasNext()) {
                if (buttonList == null) continue;
                Action button = (Action)buttonList.next();
                component.addHeaderButton(button);
            }
        }
        if (footerComponent != null) {
            component.setFooterComponent(footerComponent);
        }
        return component;
    }

    public static JSplitPane createLeftRightSplitPane() {
        return ComponentFactory.createLeftRightSplitPane(true);
    }

    public static JSplitPane createLeftRightSplitPane(boolean autoResize) {
        JSplitPane pane = ComponentFactory.createSplitPane(1, autoResize, 0.0);
        pane.setOneTouchExpandable(true);
        return pane;
    }

    public static JSplitPane createLeftRightSplitPane(Component left, Component right) {
        return ComponentFactory.createLeftRightSplitPane(left, right, true);
    }

    public static JSplitPane createLeftRightSplitPane(Component left, Component right, boolean autoResize) {
        JSplitPane pane = ComponentFactory.createLeftRightSplitPane(autoResize);
        pane.setLeftComponent(left);
        pane.setRightComponent(right);
        return pane;
    }

    public static JList createList(Action action) {
        return ComponentFactory.createList(action, false);
    }

    public static JList createList(Action action, boolean enableDragAndDrop) {
        return ComponentFactory.createSelectableList(action, enableDragAndDrop);
    }

    public static JMenuItem createMenuItem(String s) {
        JMenuItem item = new JMenuItem(s){
            private static final long serialVersionUID = 1486086160611316619L;

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }
        };
        return item;
    }

    public static JMenu createMenu() {
        JMenu menu = new JMenu();
        return menu;
    }

    public static JMenu createMenu(String text) {
        JMenu menu = ComponentFactory.createMenu();
        menu.setText(text);
        return menu;
    }

    public static JMenu createMenu(ResourceKey key) {
        JMenu menu = ComponentFactory.createMenu();
        menu.setText(LocalizedText.getText(key));
        menu.setMnemonic(LocalizedText.getMnemonic(key));
        return menu;
    }

    public static JMenu createMenu(String text, int mnemonic) {
        JMenu menu = ComponentFactory.createMenu(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public static JPanel createPanel() {
        JPanel panel = new JPanel();
        return panel;
    }

    public static JPasswordField createPasswordField() {
        JPasswordField passwordField = new JPasswordField(){
            private static final long serialVersionUID = 8866087407475720099L;

            public Dimension getPreferredSize() {
                return ComponentFactory.fieldPreferredHeightSize(super.getPreferredSize());
            }
        };
        return passwordField;
    }

    public static JRadioButton createRadioButton(String string) {
        return new JRadioButton(string);
    }

    public static JRadioButton createRadioButton(Action action) {
        return new JRadioButton(action);
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(Action action) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem();
        ComponentFactory.initializeAbstractButton(item, action);
        return item;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(Action action, boolean selected) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setSelected(selected);
        ComponentFactory.initializeAbstractButton(item, action);
        return item;
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(JMenu menu, Action action, boolean selected) {
        JCheckBoxMenuItem item = ComponentFactory.createCheckBoxMenuItem(action, selected);
        menu.add(item);
        return item;
    }

    public static JScrollPane createScrollPane() {
        JScrollPane pane = new JScrollPane();
        return pane;
    }

    public static JScrollPane createScrollPane(JComponent c) {
        JScrollPane pane = new JScrollPane(c);
        return pane;
    }

    public static JScrollPane createScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        pane.getViewport().setBackground(table.getBackground());
        return pane;
    }

    public static SelectableList createSelectableList(Action action) {
        return ComponentFactory.createSelectableList(action, false);
    }

    public static SelectableList createSelectableList(Action action, boolean enableDragAndDrop) {
        SelectableList list = new SelectableList();
        ComponentFactory.configureList(list, action, enableDragAndDrop);
        return list;
    }

    public static SelectableTable createSelectableTable(Action action) {
        SelectableTable table = new SelectableTable();
        if (action != null) {
            table.addMouseListener(new DoubleClickActionAdapter(action));
        }
        table.setShowGrid(false);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.setColumnSelectionAllowed(false);
        table.setAutoResizeMode(3);
        table.setAutoCreateColumnsFromModel(false);
        table.setDefaultEditor(Object.class, null);
        return table;
    }

    public static SelectableTree createSelectableTree(Action action) {
        return ComponentFactory.createSelectableTree(action, null);
    }

    public static SelectableTree createSelectableTree(Action action, LazyTreeRoot root) {
        SelectableTree tree = new SelectableTree(action, root);
        return tree;
    }

    public static SelectableList createSingleItemList(Action action) {
        SelectableList list = (SelectableList)ComponentFactory.createList(action);
        list.setPreferredSize(new Dimension(1, 25));
        list.setFixedCellHeight(21);
        list.setBorder(BorderFactory.createEtchedBorder());
        return list;
    }

    private static void setSplitPaneComponentMinimumSize(Component c) {
        if (c instanceof JComponent) {
            ((JComponent)c).setMinimumSize(new Dimension(0, 0));
        }
    }

    private static JSplitPane createSplitPane(int direction, boolean autoResize, double resizeWeight) {
        JSplitPane pane = new JSplitPane(direction, autoResize){
            private static final long serialVersionUID = 6260228646159934377L;
            private boolean initialized;

            public void addImpl(Component component, Object constraint, int i) {
                super.addImpl(component, constraint, i);
                ComponentFactory.setSplitPaneComponentMinimumSize(component);
            }

            @Deprecated
            public void reshape(int x, int y, int w, int h) {
                super.reshape(x, y, w, h);
                if (!this.initialized && w != 0 && h != 0) {
                    this.initialized = true;
                    if (this.getOrientation() == 0) {
                        int location = this.getHeight() - this.getBottomComponent().getPreferredSize().height;
                        this.setDividerLocation(location);
                    } else {
                        int location = this.getLeftComponent().getPreferredSize().width;
                        location = Math.max(location, MIN_LEFT_SPLIT_PANE_WIDTH);
                        this.setDividerLocation(location);
                    }
                }
            }
        };
        pane.setBorder(null);
        pane.setResizeWeight(resizeWeight);
        return pane;
    }

    public static Border createStandardBorder() {
        return BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }

    public static Border createThinStandardBorder() {
        return BorderFactory.createEmptyBorder(3, 3, 3, 3);
    }

    public static JTabbedPane createTabbedPane(final boolean addBorder) {
        JTabbedPane pane = new JTabbedPane(){
            private static final long serialVersionUID = 2618479387074156744L;

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }

            public void addImpl(Component component, Object constraints, int index) {
                if (addBorder) {
                    JComponent c = (JComponent)component;
                    c.setBorder(BorderFactory.createCompoundBorder(ComponentFactory.createThinStandardBorder(), c.getBorder()));
                }
                super.addImpl(component, constraints, index);
            }
        };
        return pane;
    }

    public static JTable createTable(Action action) {
        return ComponentFactory.createSelectableTable(action);
    }

    public static JTextArea createTextArea() {
        JTextArea area = new JTextArea(){
            private static final long serialVersionUID = 2549315674090075218L;

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }

            public void setText(String text) {
                super.setText(text);
                this.setCaretPosition(0);
                this.repaint();
            }
        };
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        ComponentFactory.configureTextComponent(area);
        return area;
    }

    public static JTextField createTextField(String s) {
        JTextField field = ComponentFactory.createTextField();
        field.setText(s);
        return field;
    }

    public static JTextField createTextField() {
        JTextField textField = new JTextField(){
            private static final long serialVersionUID = 6399707890142979289L;

            public void paint(Graphics g) {
                ComponentUtilities.enableTextAntialiasing(g);
                super.paint(g);
            }

            public Dimension getPreferredSize() {
                return ComponentFactory.fieldPreferredHeightSize(super.getPreferredSize());
            }
        };
        ComponentFactory.configureTextComponent(textField);
        return textField;
    }

    private static void configureTextComponent(JTextComponent component) {
        ComponentFactory.addAction(component, 88, 8, new ConvertUnicodeSequenceAction());
        if (SystemUtilities.forName(UNICODE_CHOOSER_CLASS) != null) {
            ComponentFactory.addAction(component, 73, 8, new InsertUnicodeCharacterAction());
        }
    }

    private static void addAction(JTextComponent component, int keyCode, int modifiers, Action action) {
        Keymap keymap = component.getKeymap();
        KeyStroke stroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        keymap.addActionForKeyStroke(stroke, action);
    }

    public static JTextPane createTextPane() {
        JTextPane pane = new JTextPane();
        return pane;
    }

    public static JToggleButton createToggleButton(Action action) {
        JToggleButton button = new JToggleButton(){
            private static final long serialVersionUID = 8473450251620423797L;

            public Dimension getPreferredSize() {
                return ComponentFactory.buttonPreferredHeightSize(super.getPreferredSize());
            }
        };
        ComponentFactory.initializeAbstractButton(button, action);
        return button;
    }

    public static JToolBar createToolBar() {
        JToolBar bar = new JToolBar(){
            private static final long serialVersionUID = -4194085314294949784L;

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 25;
                return d;
            }
        };
        bar.setOpaque(false);
        bar.setRollover(true);
        bar.setFloatable(false);
        bar.setBorderPainted(false);
        bar.setBorder(null);
        return bar;
    }

    public static JSplitPane createTopBottomSplitPane(boolean autoResize) {
        return ComponentFactory.createSplitPane(0, autoResize, 1.0);
    }

    public static JSplitPane createTopBottomSplitPane() {
        return ComponentFactory.createTopBottomSplitPane(true);
    }

    public static JSplitPane createTopBottomSplitPane(Component top, Component bottom) {
        return ComponentFactory.createTopBottomSplitPane(top, bottom, true);
    }

    public static JSplitPane createTopBottomSplitPane(Component top, Component bottom, boolean autoResize) {
        JSplitPane pane = ComponentFactory.createTopBottomSplitPane(autoResize);
        pane.setTopComponent(top);
        pane.setBottomComponent(bottom);
        return pane;
    }

    public static JTree createTree(Action action) {
        return ComponentFactory.createSelectableTree(action);
    }

    public static JWindow createWindow() {
        JWindow window = new JWindow();
        return window;
    }

    private static Dimension fieldPreferredHeightSize(Dimension d) {
        d.height = 25;
        return d;
    }

    public static JComponent getCloseButtonPanel(final JFrame frame) {
        JPanel c = new JPanel();
        c.setLayout(new FlowLayout());
        JButton button = ComponentFactory.createButton(new AbstractAction("Close", Icons.getCloseIcon()){
            private static final long serialVersionUID = 7477504460910818473L;

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.closeWindow(frame);
            }
        });
        c.add(button);
        return c;
    }

    private static void initializeAbstractButton(final AbstractButton button, final Action action) {
        action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                button.setEnabled(action.isEnabled());
            }
        });
        button.setEnabled(action.isEnabled());
        button.addActionListener(action);
        button.setIcon((Icon)action.getValue("SmallIcon"));
        button.setAlignmentX(0.5f);
        button.setAlignmentY(0.5f);
        button.setText((String)action.getValue("Name"));
        button.setToolTipText((String)action.getValue("ShortDescription"));
        button.setHorizontalTextPosition(4);
    }

    private static void setupDragAndDrop(JList list) {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(list, 3, new DefaultListDragSourceListener());
        new DropTarget(list, 3, new ListTarget());
    }

    public static JFrame showInFrame(Component panel, String title) {
        JFrame frame = ComponentFactory.createFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(panel, "Center");
        frame.setTitle(title);
        frame.pack();
        ComponentUtilities.center(frame);
        ComponentFactory.adjustPosition(frame);
        frame.setVisible(true);
        return frame;
    }

    public static JFrame showMessageInFrame(String message, String title) {
        JFrame frame = ComponentFactory.createFrame();
        frame.setDefaultCloseOperation(2);
        Container c = frame.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel innerPane = new JPanel(new BorderLayout());
        innerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel(message);
        innerPane.add(label);
        c.add((Component)innerPane, "Center");
        frame.pack();
        frame.setTitle(title);
        ComponentUtilities.center(frame);
        ComponentFactory.adjustPosition(frame);
        frame.setVisible(true);
        return frame;
    }

    public static void showTableRowInDialog(TableModel tableModel, int row, Component parentComp) {
        if (row < 0 || row > tableModel.getRowCount()) {
            return;
        }
        LinkedHashMap<String, String> colNameToValue = new LinkedHashMap<String, String>();
        for (int col = 0; col < tableModel.getColumnCount(); ++col) {
            String colName = tableModel.getColumnName(col);
            if (colName == null) {
                colName = "Column " + (col + 1);
            }
            colNameToValue.put(colName, tableModel.getValueAt(row, col).toString());
        }
        JPanel panel = new JPanel(new GridLayout(tableModel.getColumnCount(), 1, 5, 5));
        for (String colName : colNameToValue.keySet()) {
            panel.add(new JLabel("<html>" + colName + ": <b>" + (String)colNameToValue.get(colName) + "</b></html>"));
        }
        ModalDialog.showDialog(parentComp, panel, "Table row details", 14);
    }

    public static JEditorPane createEditorPane() {
        return new JEditorPane();
    }

    public static JEditorPane createHTMLBrowser(URL url) {
        JEditorPane pane = new JEditorPane(){
            private static final long serialVersionUID = -6684758167149030263L;

            public void paint(Graphics g) {
                ComponentUtilities.enableAllAntialiasing(g);
                super.paint(g);
            }
        };
        pane.setEditable(false);
        pane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SystemUtilities.showHTML(e.getURL().toString());
                }
            }
        });
        if (url != null) {
            ComponentFactory.setPage(pane, url);
        }
        return pane;
    }

    public static void setPage(JEditorPane pane, URL url) {
        try {
            pane.setPage(url);
        }
        catch (IOException e) {
            Log.getLogger().warning(e.toString());
        }
    }

    public static JLabel createSmallFontLabel(String text) {
        JLabel label = ComponentFactory.createLabel(text);
        ComponentUtilities.setSmallLabelFont(label);
        return label;
    }

    public static JLabel createTitleFontLabel(String text) {
        JLabel label = ComponentFactory.createLabel(text);
        ComponentUtilities.setTitleLabelFont(label);
        return label;
    }

    static {
        MIN_LEFT_SPLIT_PANE_WIDTH = ComponentFactory.getMinLeftSplitPaneWidth();
    }

    private static class DisposableFrame
    extends JFrame
    implements Disposable {
        private static final long serialVersionUID = 1208382900963856453L;

        DisposableFrame() {
            ComponentUtilities.registerWindow(this);
            this.enableEvents(64L);
        }

        public void processWindowEvent(WindowEvent event) {
            if (event.getID() == 202) {
                ComponentUtilities.deregisterWindow(this);
            }
            super.processWindowEvent(event);
        }
    }
}

