/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Traverser;
import edu.stanford.smi.protege.util.TreeSelectionHelper;
import edu.stanford.smi.protege.util.UnaryFunction;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentUtilities {
    private static final int BORDER_SIZE = 50;
    private static final int STANDARD_ROW_HEIGHT = 60;
    private static final int STANDARD_COLUMN_WIDTH = 100;
    private static Collection _openWindows = new ArrayList();

    public static TableColumn addColumn(JTable table, TableCellRenderer renderer) {
        return ComponentUtilities.addColumn(table, null, renderer);
    }

    public static TableColumn addColumn(JTable table, String header, TableCellRenderer renderer) {
        return ComponentUtilities.addColumn(table, renderer, null);
    }

    public static TableColumn addColumn(JTable table, TableCellRenderer renderer, TableCellEditor editor) {
        return ComponentUtilities.addColumn(table, renderer, null, editor);
    }

    public static TableColumn addColumn(JTable table, TableCellRenderer renderer, String header, TableCellEditor editor) {
        int nColumns = table.getColumnCount();
        TableColumn column = new TableColumn(nColumns);
        column.setCellRenderer(renderer);
        column.setCellEditor(editor);
        column.setHeaderValue(header);
        table.addColumn(column);
        return column;
    }

    public static int addListValue(JList list, Object newValue) {
        return ComponentUtilities.getModel(list).addValue(newValue);
    }

    public static void addListValue(JList list, Object newValue, int index) {
        ComponentUtilities.getModel(list).addValue(newValue, index);
    }

    public static int addListValue(JList list, Object newValue, Comparator comparator) {
        int index = ComponentUtilities.getPositionIndex(list, newValue, comparator);
        ComponentUtilities.addListValue(list, newValue, index);
        return index;
    }

    public static void addListValues(JList list, Collection newValues) {
        if (!newValues.isEmpty()) {
            ComponentUtilities.getModel(list).addValues(newValues);
        }
    }

    public static int addSelectedListValue(JList list, Object newValue) {
        int index = ComponentUtilities.getModel(list).addValue(newValue);
        list.setSelectedIndex(index);
        return index;
    }

    public static void addSelectedListValues(JList list, Collection newValues) {
        if (!newValues.isEmpty()) {
            int index = ComponentUtilities.getModel(list).addValues(newValues);
            list.setSelectionInterval(index, index + newValues.size() - 1);
        }
    }

    public static void addUniqueListValues(JList list, Collection newValues) {
        HashSet uniqueValues = new HashSet(newValues);
        uniqueValues.removeAll(ComponentUtilities.getModel(list).getValues());
        ComponentUtilities.addListValues(list, uniqueValues);
    }

    public static void apply(Component component, UnaryFunction f) {
        f.apply(component);
        ComponentUtilities.applyToDescendents(component, f);
    }

    public static void applyToDescendents(Component component, UnaryFunction f) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component subComponent = container.getComponent(i);
                ComponentUtilities.apply(subComponent, f);
            }
        }
    }

    public static void center(Component c) {
        Dimension screenSize = c.getToolkit().getScreenSize();
        screenSize.width -= 50;
        screenSize.height -= 50;
        Dimension componentSize = c.getSize();
        int xPos = (screenSize.width - componentSize.width) / 2;
        xPos = Math.max(xPos, 0);
        int yPos = (screenSize.height - componentSize.height) / 2;
        yPos = Math.max(yPos, 0);
        c.setLocation(new Point(xPos, yPos));
    }

    public static void clearListValues(JList list) {
        ComponentUtilities.getModel(list).clear();
    }

    private static void clearSelectionIfNecessary(JList list, int count) {
        if (list.getModel().getSize() == count) {
            list.clearSelection();
        }
    }

    public static void closeAllWindows() {
        for (Window w : new ArrayList(_openWindows)) {
            ComponentUtilities.closeWindow(w);
        }
    }

    public static void closeWindow(Window window) {
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    public static void deregisterWindow(Window window) {
        _openWindows.remove(window);
    }

    private static void disassemble(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int nSubcomponents = container.getComponentCount();
            for (int i = 0; i < nSubcomponents; ++i) {
                ComponentUtilities.disassemble(container.getComponent(i));
            }
            container.removeAll();
        }
    }

    public static void dispose(Component component) {
        if (component != null) {
            component.setVisible(false);
            UnaryFunction dispose = new UnaryFunction(){

                public Object apply(Object o) {
                    if (o instanceof Disposable) {
                        ((Disposable)o).dispose();
                    }
                    return Boolean.TRUE;
                }
            };
            ComponentUtilities.apply(component, dispose);
            ComponentUtilities.disassemble(component);
            component.setBackground(Color.pink);
            component.setForeground(Color.green);
        }
    }

    public static void ensureSelectionIsVisible(JList list) {
    }

    public static void extendSelection(JTree tree, Object userObject) {
        LazyTreeNode selectedNode = (LazyTreeNode)tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        int index = selectedNode.getUserObjectIndex(userObject);
        if (index == -1) {
            Log.getLogger().warning("object not found: " + userObject);
        } else {
            TreeNode node = selectedNode.getChildAt(index);
            ComponentUtilities.setSelectedNode(tree, node);
        }
    }

    private static int fullExpand(JTree tree, TreePath parentPath, int nExpansions) {
        TreeNode parent = (TreeNode)parentPath.getLastPathComponent();
        int count = parent.getChildCount();
        for (int i = 0; i < count && nExpansions > 0; ++i) {
            TreeNode child = parent.getChildAt(i);
            TreePath childPath = parentPath.pathByAddingChild(child);
            nExpansions = ComponentUtilities.fullExpand(tree, childPath, nExpansions);
        }
        tree.expandPath(parentPath);
        return --nExpansions;
    }

    public static void fullSelectionCollapse(JTree tree) {
        int startRow = tree.getLeadSelectionRow();
        int stopRow = ComponentUtilities.getStopRow(tree, startRow);
        for (int i = stopRow - 1; i >= startRow; --i) {
            tree.collapseRow(i);
        }
    }

    public static void fullSelectionExpand(JTree tree, int max_expansions) {
        TreePath topPath = tree.getLeadSelectionPath();
        if (topPath != null) {
            ComponentUtilities.fullExpand(tree, topPath, max_expansions);
        }
    }

    public static LazyTreeNode getChildNode(LazyTreeNode node, Object userObject) {
        LazyTreeNode childNode = null;
        int nChildren = node.getChildCount();
        for (int i = 0; i < nChildren; ++i) {
            childNode = (LazyTreeNode)node.getChildAt(i);
            if (!ComponentUtilities.equals(childNode.getUserObject(), userObject)) continue;
            return childNode;
        }
        return null;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public static Component getDescendentOfClass(Class componentClass, Component root) {
        Collection c = ComponentUtilities.getDescendentsOfClass(componentClass, root);
        return (Component)CollectionUtilities.getFirstItem(c);
    }

    public static Collection getDescendentsOfClass(final Class componentClass, Component root) {
        final ArrayList results = new ArrayList();
        UnaryFunction f = new UnaryFunction(){

            public Object apply(Object o) {
                if (componentClass.isInstance(o)) {
                    results.add(o);
                }
                return null;
            }
        };
        ComponentUtilities.apply(root, f);
        return results;
    }

    public static Dialog getDialog(Component c) {
        return (Dialog)SwingUtilities.windowForComponent(c);
    }

    public static Object getFirstSelectionParent(JTree tree) {
        LazyTreeNode parentNode;
        LazyTreeNode node = (LazyTreeNode)tree.getLastSelectedPathComponent();
        Object parent = node == null ? null : ((parentNode = node.getLazyTreeNodeParent()) instanceof LazyTreeRoot ? null : parentNode.getUserObject());
        return parent;
    }

    public static Frame getFrame(Component c) {
        Frame frame = c instanceof Frame ? (Frame)c : (Frame)SwingUtilities.windowForComponent(c);
        return frame;
    }

    public static Collection getListValues(JList list) {
        ListModel model = list.getModel();
        if (model instanceof SimpleListModel) {
            return ((SimpleListModel)model).getValues();
        }
        return ComponentUtilities.getGenericListValues(list);
    }

    private static Collection getGenericListValues(JList list) {
        ArrayList values = new ArrayList();
        ListModel model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            values.add(model.getElementAt(i));
        }
        return values;
    }

    private static SimpleListModel getModel(JList list) {
        SimpleListModel model = list.getModel();
        if (!(model instanceof SimpleListModel)) {
            model = new SimpleListModel();
            list.setModel(model);
        }
        return model;
    }

    private static int getPositionIndex(JList list, Object value, Comparator comparator) {
        int index = Collections.binarySearch(ComponentUtilities.getModel(list).getValues(), value, comparator);
        if (index < 0) {
            index = -(index + 1);
        }
        return index;
    }

    public static Object getSelectedValue(JList list) {
        return CollectionUtilities.getFirstItem(ComponentUtilities.getSelection(list));
    }

    public static Collection getSelection(JList list) {
        return Arrays.asList(list.getSelectedValues());
    }

    public static void setSelectedValue(JList list, Object value) {
        list.setSelectedValue(value, true);
    }

    public static void setSelectedValues(JList list, Collection values) {
        int[] indexes = new int[values.size()];
        int count = 0;
        for (Object o : values) {
            indexes[count++] = ComponentUtilities.indexOf(list, o);
        }
        list.setSelectedIndices(indexes);
    }

    private static int indexOf(JList list, Object o) {
        int index = -1;
        ListModel model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object element = model.getElementAt(i);
            if (!element.equals(o)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static Collection getSelection(JTable table) {
        TableModel model = table.getModel();
        int[] indices = table.getSelectedRows();
        ArrayList<Object> selection = new ArrayList<Object>();
        for (int i = 0; i < indices.length; ++i) {
            selection.add(model.getValueAt(indices[i], 0));
        }
        return selection;
    }

    public static Collection getSelection(JTree tree) {
        return ComponentUtilities.getSelection(tree, Object.class);
    }

    public static Collection getSelection(JTree tree, Class c) {
        Assert.assertNotNull("tree", tree);
        LinkedHashSet<Object> selections = new LinkedHashSet<Object>();
        TreePath[] paths = tree.getSelectionModel().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                TreePath path = paths[i];
                if (path.getPathCount() <= 1) continue;
                Object o = paths[i].getLastPathComponent();
                if (o instanceof LazyTreeNode) {
                    o = ((LazyTreeNode)o).getUserObject();
                }
                if (c != null && !c.isInstance(o)) continue;
                selections.add(o);
            }
        }
        return selections;
    }

    public static int getStandardColumnWidth() {
        return 100;
    }

    public static int getStandardRowHeight() {
        return 60;
    }

    private static int getStopRow(JTree tree, int startRow) {
        int last;
        int startDepth = tree.getPathForRow(startRow).getPathCount();
        int stopRow = last = tree.getRowCount();
        for (int i = startRow + 1; i < last; ++i) {
            int depth = tree.getPathForRow(i).getPathCount();
            if (depth > startDepth) continue;
            stopRow = i;
            break;
        }
        return stopRow;
    }

    public static TreePath getTreePath(JTree tree, Collection objectPath) {
        LinkedList<LazyTreeNode> nodePath = new LinkedList<LazyTreeNode>();
        LazyTreeNode node = (LazyTreeNode)tree.getModel().getRoot();
        nodePath.add(node);
        for (Object userObject : objectPath) {
            if ((node = ComponentUtilities.getChildNode(node, userObject)) == null) {
                return null;
            }
            nodePath.add(node);
        }
        return new TreePath(nodePath.toArray());
    }

    public static Collection getObjectPath(TreePath path) {
        ArrayList<Object> objectPath = new ArrayList<Object>();
        Object[] nodePath = path.getPath();
        for (int i = 1; i < nodePath.length; ++i) {
            TreeNode node = (TreeNode)nodePath[i];
            if (!(node instanceof LazyTreeNode)) continue;
            Object o = ((LazyTreeNode)node).getUserObject();
            objectPath.add(o);
        }
        return objectPath;
    }

    public static void hide(final Component c, final int delayInMillisec) {
        Thread t = new Thread(){

            public void run() {
                try {
                    3.sleep(delayInMillisec);
                    Component topComponent = SwingUtilities.getRoot(c);
                    topComponent.setVisible(false);
                }
                catch (Exception e) {
                    Log.getLogger().severe(Log.toString(e));
                }
            }
        };
        t.start();
    }

    public static boolean isDragAndDropEnabled(JComponent c) {
        Object o = c.getClientProperty(ComponentUtilities.class);
        return o == null ? true : (Boolean)o;
    }

    public static boolean listValuesContain(JList list, Object value) {
        return ComponentUtilities.getModel(list).contains(value);
    }

    public static ImageIcon loadImageIcon(Class clas, String iconPath) {
        ImageIcon icon = null;
        URL url = clas.getResource(iconPath);
        if (url != null) {
            icon = new ImageIcon(url);
        }
        return icon;
    }

    public static void pack(Component c) {
        Frame window = ComponentUtilities.getFrame(c);
        window.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension bounds = new Dimension();
        bounds.width = Math.min(window.getWidth(), screenSize.width * 8 / 10);
        bounds.height = Math.min(window.getHeight(), screenSize.height * 8 / 10);
        window.setSize(bounds);
    }

    public static Dimension getDefaultMainFrameSize() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.width = size.width * 8 / 10;
        size.height = size.height * 8 / 10;
        return size;
    }

    public static void paintImmediately(Component component) {
        Graphics g = component.getGraphics();
        component.paint(g);
        g.dispose();
    }

    public static void registerWindow(Window window) {
        _openWindows.add(window);
    }

    public static void removeListValue(JList list, Object oldValue) {
        ComponentUtilities.clearSelectionIfNecessary(list, 1);
        int selectedIndex = list.getSelectedIndex();
        int index = ComponentUtilities.getModel(list).removeValue(oldValue);
        if (selectedIndex == index) {
            ComponentUtilities.setSelectedIndex(list, index);
        }
    }

    public static void removeListValues(JList list, Collection values) {
        ComponentUtilities.clearSelectionIfNecessary(list, values.size());
        int selectedIndex = list.getSelectedIndex();
        int index = ComponentUtilities.getModel(list).removeValues(values);
        if (selectedIndex == index) {
            ComponentUtilities.setSelectedIndex(list, index);
        }
    }

    public static void removeSelection(JTree tree) {
        LazyTreeNode selectedNode = (LazyTreeNode)tree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            int nChildren;
            LazyTreeNode parentNode = selectedNode.getLazyTreeNodeParent();
            int index = parentNode.getUserObjectIndex(selectedNode.getUserObject());
            TreeNode newSelection = index == (nChildren = parentNode.getChildCount()) - 1 ? (nChildren == 1 ? parentNode : parentNode.getChildAt(index - 1)) : parentNode.getChildAt(index + 1);
            ComponentUtilities.setSelectedNode(tree, newSelection);
        }
    }

    public static void replaceListValue(JList list, Object oldValue, Object newValue) {
        SimpleListModel model = ComponentUtilities.getModel(list);
        if (newValue == null) {
            model.removeValue(oldValue);
        } else {
            int index = model.indexOf(oldValue);
            if (index != -1) {
                model.setValue(index, newValue);
            }
        }
    }

    public static void reposition(JList list, Object value, Comparator comparator) {
        int oldSelectionIndex = list.getSelectedIndex();
        SimpleListModel model = ComponentUtilities.getModel(list);
        int fromIndex = model.indexOf(value);
        model.removeValue(value);
        int toIndex = ComponentUtilities.getPositionIndex(list, value, comparator);
        ComponentUtilities.getModel(list).addValue(value, toIndex);
        if (oldSelectionIndex != -1) {
            int newSelectionIndex = oldSelectionIndex;
            if (fromIndex == oldSelectionIndex) {
                newSelectionIndex = toIndex;
            } else if (fromIndex < oldSelectionIndex && toIndex > oldSelectionIndex) {
                --newSelectionIndex;
            } else if (fromIndex > oldSelectionIndex && toIndex < oldSelectionIndex) {
                ++newSelectionIndex;
            }
            list.setSelectedIndex(newSelectionIndex);
            list.ensureIndexIsVisible(newSelectionIndex);
        }
    }

    public static void setDragAndDropEnabled(JComponent c, boolean enable) {
        c.putClientProperty(ComponentUtilities.class, enable);
    }

    public static void setEnabled(Component component, final boolean enabled) {
        ComponentUtilities.apply(component, new UnaryFunction(){

            public Object apply(Object o) {
                ((Component)o).setEnabled(enabled);
                return null;
            }
        });
    }

    public static void setExpanded(JTree tree, Collection objectPath, boolean expand) {
        TreePath path = ComponentUtilities.getTreePath(tree, objectPath);
        if (path != null) {
            if (expand) {
                tree.scrollPathToVisible(path);
                tree.expandPath(path);
                tree.updateUI();
            } else {
                tree.collapsePath(path);
            }
        }
    }

    public static void setFrameTitle(Component c, String title) {
        ComponentUtilities.getFrame(c).setTitle(title);
    }

    public static void setListValues(JList list, Collection values) {
        ComponentUtilities.getModel(list).setValues(values);
    }

    private static void setSelectedIndex(JList list, int index) {
        int nElements = list.getModel().getSize();
        index = Math.min(index, nElements - 1);
        list.setSelectedIndex(index);
    }

    public static void setSelectedNode(final JTree tree, TreeNode node) {
        TreePath path = new TreePath(((LazyTreeModel)tree.getModel()).getPathToRoot(node));
        if (path != null) {
            tree.scrollPathToVisible(path);
            tree.setSelectionPath(path);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tree.updateUI();
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tree.updateUI();
            }
        });
    }

    public static void setSelectedObjectPath(final JTree tree, Collection objectPath) {
        final TreePath path = ComponentUtilities.getTreePath(tree, objectPath);
        if (path != null) {
            final WaitCursor cursor = new WaitCursor(tree);
            tree.scrollPathToVisible(path);
            tree.updateUI();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tree.setSelectionPath(path);
                    tree.updateUI();
                    cursor.hide();
                }
            });
        }
    }

    public static void setSelectedObjectPaths(JTree tree, Collection objectPaths) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        for (Collection objectPath : objectPaths) {
            treePaths.add(ComponentUtilities.getTreePath(tree, objectPath));
        }
        TreePath[] paths = treePaths.toArray(new TreePath[treePaths.size()]);
        tree.setSelectionPaths(paths);
        if (paths.length > 0) {
            tree.scrollPathToVisible(paths[0]);
            tree.updateUI();
        }
    }

    public static void requestFocus(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.requestFocus();
            }
        });
    }

    public static void setDisplayParent(JTree tree, Object parent, Traverser traverser) {
        Object child = ((LazyTreeNode)tree.getSelectionPath().getLastPathComponent()).getUserObject();
        ComponentUtilities.setDisplayParent(tree, parent, child, traverser);
    }

    public static void setDisplayParent(JTree tree, Object parent, Object child, Traverser traverser) {
        LinkedList<Object> objects = new LinkedList<Object>();
        objects.add(0, child);
        while (parent != null) {
            objects.add(0, parent);
            parent = traverser.get(parent);
        }
        TreeNode node = (TreeNode)tree.getModel().getRoot();
        Iterator i = objects.iterator();
        while (i.hasNext() && node != null) {
            Object o = i.next();
            node = ComponentUtilities.getMatchingChildNode(node, o);
        }
        if (node != null) {
            ComponentUtilities.setSelectedNode(tree, node);
        }
    }

    private static TreeNode getMatchingChildNode(TreeNode node, Object child) {
        LazyTreeNode matchingNode = null;
        for (int childIndex = 0; childIndex < node.getChildCount(); ++childIndex) {
            LazyTreeNode childNode = (LazyTreeNode)node.getChildAt(childIndex);
            if (!ComponentUtilities.equals(childNode.getUserObject(), child)) continue;
            matchingNode = childNode;
            break;
        }
        return matchingNode;
    }

    public static JLabel setTitleLabelFont(JLabel label) {
        return ComponentUtilities.modifyLabelFont(label, 1, 0);
    }

    public static JLabel setSmallLabelFont(JLabel label) {
        return ComponentUtilities.modifyLabelFont(label, 1, 0);
    }

    public static JLabel modifyLabelFont(JLabel label, int style, int delta) {
        Font font = label.getFont();
        label.setFont(font.deriveFont(style, font.getSize() + delta));
        label.setForeground(new Color(140, 140, 140));
        return label;
    }

    public static void enableTextAntialiasing(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        if (SystemUtilities.useAntialiasing()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public static void enableAllAntialiasing(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        if (SystemUtilities.useAntialiasing()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public static Border getAlignBorder() {
        return BorderFactory.createEmptyBorder(5, 0, 0, 0);
    }

    public static void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        table.scrollRectToVisible(rect);
    }

    public static JMenu getMenu(JMenuBar menuBar, String menuText) {
        return ComponentUtilities.getMenu(menuBar, menuText, false);
    }

    public static JMenu getMenu(JMenuBar menuBar, String menuText, boolean create) {
        return ComponentUtilities.getMenu(menuBar, menuText, create, menuBar.getMenuCount());
    }

    public static JMenu getMenu(JMenuBar menuBar, String menuText, boolean create, int menuIndex) {
        int menuCount = menuBar.getMenuCount();
        for (int i = 0; i < menuCount; ++i) {
            JMenu tmpMenu = menuBar.getMenu(i);
            if (!tmpMenu.getText().equals(menuText)) continue;
            return tmpMenu;
        }
        if (create) {
            JMenu menu = new JMenu(menuText);
            menuBar.add((Component)menu, menuIndex);
            menuBar.revalidate();
            menuBar.repaint();
            return menu;
        }
        return null;
    }

    public static void removeMenuItem(JMenu menu, String menuItemText) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !menuItemText.equals(item.getText())) continue;
            menu.remove(item);
        }
    }

    public static void setSelectedNode(final KnowledgeBase kb, JTree tree, FrameWithBrowserText value) {
        TreeSelectionHelper<FrameWithBrowserText> selectionHelper = new TreeSelectionHelper<FrameWithBrowserText>(tree){
            private Slot superclsesSlot;
            {
                super(x0);
                this.superclsesSlot = kb.getSystemFrames().getDirectSuperclassesSlot();
            }

            @Override
            protected Collection<FrameWithBrowserText> getParents(FrameWithBrowserText child) {
                edu.stanford.smi.protege.model.Frame frame = child.getFrame();
                return FrameWithBrowserText.getFramesWithBrowserText(frame.getOwnSlotValues(this.superclsesSlot));
            }

            @Override
            protected boolean isVisible(FrameWithBrowserText element) {
                edu.stanford.smi.protege.model.Frame frame = element.getFrame();
                return frame.isVisible();
            }
        };
        selectionHelper.setSelectedNode(value);
    }
}

