/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;

public class DefaultLogger
implements Log.LegacyLogger {
    private static final boolean INDENTATION_ENABLED = false;
    private int _nEntries = 0;
    private PrintWriter _writer;
    private boolean _displayTrace = true;
    private boolean _displayWarnings = true;
    private boolean _doPause = false;
    private boolean _showStack = false;
    private int _directTraceCount;
    private int _directWarningCount;
    private int _directErrorCount;

    public DefaultLogger() {
        this._writer = new PrintWriter(System.err);
    }

    public DefaultLogger(Writer writer) {
        this._writer = new PrintWriter(writer);
    }

    private String createMessage(String prefix, String entry, Object object, String methodName, Object[] arguments) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        String className = object instanceof Class ? StringUtilities.getClassName((Class)object) : StringUtilities.getClassName(object);
        buf.append(className);
        buf.append(".");
        buf.append(methodName);
        buf.append("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(DefaultLogger.toString(arguments[i]));
        }
        buf.append(")");
        buf.append(" ");
        buf.append(entry);
        if (!(object instanceof Class)) {
            buf.append(" - ");
            buf.append(object);
            buf.append(" ");
            buf.append(Integer.toHexString(object.hashCode()).toUpperCase());
        }
        return buf.toString();
    }

    public void enter(Object object, String methodName, Object[] arguments) {
        this.trace("enter", object, methodName, arguments);
        ++this._nEntries;
    }

    public void error(String entry, Object object, String methodName, Object[] arguments) {
        this.output("ERROR", entry, object, methodName, arguments);
        ++this._directErrorCount;
    }

    public void exception(Throwable t, Object object, String methodName, Object[] arguments) {
        this.output("Exception", "failed", object, methodName, arguments);
        t.printStackTrace(this._writer);
        this._writer.flush();
        ++this._directErrorCount;
    }

    public void exit(Object object, String methodName, Object[] arguments) {
        this.trace("exit", object, methodName, arguments);
        --this._nEntries;
    }

    public int getErrorCount() {
        return this._directErrorCount;
    }

    public int getTraceCount() {
        return this._directTraceCount + this.getWarningCount();
    }

    public int getWarningCount() {
        return this._directWarningCount + this.getErrorCount();
    }

    private void output(String prefix, String entry, Object object, String methodName, Object[] arguments) {
        this.output(prefix, entry, object, methodName, arguments, false);
    }

    private void output(String prefix, String entry, Object object, String methodName, Object[] arguments, boolean stack) {
        String message = this.createMessage(prefix, entry, object, methodName, arguments);
        if (stack || this._showStack) {
            new Throwable(message).printStackTrace(this._writer);
        } else {
            this._writer.println(message);
        }
        this._writer.flush();
        if (this._doPause) {
            SystemUtilities.pause();
        }
    }

    public void resetCounts() {
        this._directTraceCount = 0;
        this._directWarningCount = 0;
        this._directErrorCount = 0;
    }

    public void setDisplayTrace(boolean b) {
        this._displayTrace = b;
    }

    public void setDisplayWarnings(boolean b) {
        this._displayWarnings = b;
    }

    public void setDoPause(boolean b) {
        this._doPause = b;
    }

    public void setShowStack(boolean b) {
        this._showStack = b;
    }

    public void stack(String entry, Object object, String method, Object[] arguments) {
        this.output("Stack Dump", entry, object, method, arguments, true);
        ++this._directTraceCount;
    }

    private static String toString(Object o) {
        String string;
        try {
            string = o == null ? null : (o instanceof Collection ? "[" + CollectionUtilities.toString((Collection)o) + "]" : (o.getClass().isArray() ? "{" + CollectionUtilities.toString(Arrays.asList((Object[])o)) + "}" : o.toString()));
        }
        catch (Exception e) {
            string = "<<toString() exception>>";
        }
        return string;
    }

    public void trace(String entry, Object object, String methodName, Object[] arguments) {
        if (this._displayTrace) {
            this.output("Trace", entry, object, methodName, arguments);
        }
        ++this._directTraceCount;
    }

    public void warning(String entry, Object object, String methodName, Object[] arguments) {
        if (this._displayWarnings || this._displayTrace) {
            this.output("Warning", entry, object, methodName, arguments);
        }
        ++this._directWarningCount;
    }
}

