/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DefaultRenderer
extends JComponent
implements TreeCellRenderer,
ListCellRenderer,
TableCellRenderer {
    private static final long serialVersionUID = -5077332037549517658L;
    public static final Object DROP_TARGET = new Object();
    public static final Object DROP_TARGET_AREA = new Object();
    public static final Object DROP_TARGET_AREA_ON = new Object();
    public static final Object DROP_TARGET_AREA_BELOW = new Object();
    public static final Object DROP_TARGET_AREA_ABOVE = new Object();
    protected Color _backgroundNormalColor;
    protected Color _foregroundNormalColor;
    protected Color _backgroundSelectionColor;
    protected Color _foregroundSelectionColor;
    protected Color _backgroundSelectionColorOverride;
    private static final int ICON_TEXT_GAP = 3;
    private static final int TEXT_ICON_GAP = 0;
    private static final int ICON_ICON_GAP = 0;
    private static final int TEXT_TEXT_GAP = 0;
    protected FontMetrics _fontMetrics;
    protected LookAndFeel _cachedLookAndFeel;
    protected boolean _hasFocus;
    protected boolean _isSelected;
    protected boolean _grayedText;
    protected boolean _grayedSecondaryText = true;
    protected Color _focusRectColor = Color.GRAY;
    protected List _elements = new ArrayList();
    protected Object _dropTargetArea;
    protected Color _dropTargetLineColor = Color.black;
    protected Color _treeForegroundSelectionColor;
    protected Color _treeBackgroundSelectionColor;
    protected Color _treeForegroundNormalColor;
    protected Color _treeBackgroundNormalColor;
    protected JTree _tree;
    protected int _row;
    protected Object _value;
    private boolean gettingRowBounds;

    public DefaultRenderer() {
        this.loadTreeColors();
    }

    public void setBackgroundSelectionColor(Color color) {
        this._backgroundSelectionColorOverride = color;
    }

    protected void checkDropTarget(Component component, Object value) {
        DropTarget d = component.getDropTarget();
        if (d != null && d.isActive()) {
            Object o = ((JComponent)component).getClientProperty(DROP_TARGET);
            this._dropTargetArea = DefaultRenderer.equals(o, value) ? ((JComponent)component).getClientProperty(DROP_TARGET_AREA) : null;
        }
    }

    protected Object getValue() {
        return this._value;
    }

    protected void setFontStyle(int style) {
        this.setFont(this.getFont().deriveFont(style));
    }

    protected Color getBackgroundColor() {
        return this._isSelected ? this.getBackgroundSelectionColor() : this._backgroundNormalColor;
    }

    protected Color getBackgroundSelectionColor() {
        return this._backgroundSelectionColorOverride == null ? this._backgroundSelectionColor : this._backgroundSelectionColorOverride;
    }

    public Component getListCellRendererComponent(JList list, Object value, int row, boolean selected, boolean hasFocus) {
        this._foregroundSelectionColor = list.getSelectionForeground();
        this._backgroundSelectionColor = list.getSelectionBackground();
        this._foregroundNormalColor = list.getForeground();
        this._backgroundNormalColor = list.getBackground();
        return this.setup(list, value, hasFocus, selected);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(0, this._fontMetrics.getHeight());
        Object previousElement = null;
        for (Object element : this._elements) {
            d.width += DefaultRenderer.getGap(previousElement, element);
            this.updateSize(d, element);
            previousElement = element;
        }
        if (this._tree != null && !this.gettingRowBounds) {
            this.gettingRowBounds = true;
            Rectangle bounds = this._tree.getRowBounds(this._row);
            if (bounds != null) {
                d.width = Math.max(d.width, DefaultRenderer.getNiceWidth(this._tree, bounds.x));
            }
            this.gettingRowBounds = false;
        }
        return d;
    }

    private static int getNiceWidth(JComponent component, int x) {
        int width;
        JViewport port = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, component);
        if (port != null) {
            Rectangle r = port.getViewRect();
            width = r.x + r.width - x;
        } else {
            width = component.getWidth() - x;
        }
        return width;
    }

    private static int getGap(Object previousElement, Object currentElement) {
        int gap = previousElement == null ? (currentElement instanceof String ? 3 : 0) : (previousElement instanceof Icon ? (currentElement instanceof Icon ? 0 : 3) : (currentElement instanceof Icon ? 0 : 0));
        return gap;
    }

    private void updateSize(Dimension d, Object element) {
        if (element instanceof Icon) {
            DefaultRenderer.updatePreferredSize(d, (Icon)element);
        } else if (element instanceof String) {
            this.updatePreferredSize(d, (String)element);
        } else {
            Log.getLogger().warning("Strange thing in element list: " + element);
        }
    }

    private static void updatePreferredSize(Dimension d, Icon icon) {
        d.width += icon.getIconHeight();
        d.height = Math.max(d.height, icon.getIconHeight());
    }

    private void updatePreferredSize(Dimension d, String text) {
        d.width += this._fontMetrics.stringWidth(text);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
        this._foregroundSelectionColor = table.getSelectionForeground();
        this._backgroundSelectionColor = table.getSelectionBackground();
        this._foregroundNormalColor = table.getForeground();
        this._backgroundNormalColor = table.getBackground();
        return this.setup(table, value, hasFocus, selected);
    }

    protected Color getTextColor() {
        Color textColor = this._isSelected ? (this._backgroundSelectionColorOverride == null ? this._foregroundSelectionColor : this._foregroundNormalColor) : (this._grayedText ? Color.darkGray : this._foregroundNormalColor);
        return textColor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this._foregroundSelectionColor = this._treeForegroundSelectionColor;
        this._backgroundSelectionColor = this._treeBackgroundSelectionColor;
        this._foregroundNormalColor = this._treeForegroundNormalColor;
        this._backgroundNormalColor = this._treeBackgroundNormalColor;
        this._tree = tree;
        this._row = row;
        return this.setup(tree, value, hasFocus, selected);
    }

    public void load(Object o) {
        this.addText(o.toString());
    }

    public void loadNull() {
        this.addText("<null>");
    }

    protected void loadTreeColors() {
        this._treeForegroundSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this._treeBackgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this._treeForegroundNormalColor = UIManager.getColor("Tree.textForeground");
        this._treeBackgroundNormalColor = UIManager.getColor("Tree.textBackground");
    }

    public void paint(Graphics graphics) {
        ComponentUtilities.enableTextAntialiasing(graphics);
        graphics.setFont(this.getFont());
        this._fontMetrics = graphics.getFontMetrics();
        Dimension currentSize = this.getSize();
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(0, 0, currentSize.width, currentSize.height);
        graphics.setColor(this.getTextColor());
        Point position = new Point();
        Object previousElement = null;
        boolean paintedString = false;
        for (Object currentElement : this._elements) {
            position.x += DefaultRenderer.getGap(previousElement, currentElement);
            if (currentElement instanceof Icon) {
                this.paintIcon(graphics, (Icon)currentElement, position, currentSize);
            } else if (currentElement instanceof String) {
                Color color = null;
                if (paintedString && this._grayedSecondaryText) {
                    color = Color.gray;
                }
                this.paintString(graphics, (String)currentElement, position, color, currentSize);
                paintedString = true;
            }
            previousElement = currentElement;
        }
        if (position.x > currentSize.width + 1) {
            int y = 0;
            String dots = "...";
            int dotsWidth = this._fontMetrics.stringWidth(dots);
            graphics.setColor(this.getBackgroundColor());
            graphics.fillRect(currentSize.width - dotsWidth, y, dotsWidth, currentSize.height);
            graphics.setColor(this.getTextColor());
            graphics.drawString(dots, currentSize.width - dotsWidth, y + this._fontMetrics.getAscent());
        }
        if (this._hasFocus) {
            graphics.setColor(this._focusRectColor);
            graphics.drawRect(0, 0, currentSize.width - 1, currentSize.height - 1);
        }
        if (this._dropTargetArea == DROP_TARGET_AREA_ON) {
            graphics.setColor(this._dropTargetLineColor);
            graphics.drawRect(0, 0, position.x - 1, currentSize.height - 1);
        } else if (this._dropTargetArea == DROP_TARGET_AREA_BELOW) {
            graphics.setColor(this._dropTargetLineColor);
            int y = currentSize.height - 1;
            graphics.drawLine(0, y, currentSize.width - 1, y);
        } else if (this._dropTargetArea == DROP_TARGET_AREA_ABOVE) {
            graphics.setColor(this._dropTargetLineColor);
            graphics.drawLine(0, 0, currentSize.width - 1, 0);
        }
    }

    protected void paintIcon(Graphics graphics, Icon icon, Point position, Dimension size) {
        int y = (size.height - icon.getIconHeight()) / 2;
        icon.paintIcon(this, graphics, position.x, y);
        position.x += icon.getIconWidth();
    }

    protected void paintString(Graphics graphics, String text, Point position, Dimension size) {
        this.paintString(graphics, text, position, null, size);
    }

    protected void paintString(Graphics graphics, String text, Point position, Color color, Dimension size) {
        if (color != null) {
            graphics.setColor(color);
        }
        int y = (size.height + this._fontMetrics.getAscent()) / 2 - 2;
        graphics.drawString(text, position.x, y);
        position.x += this._fontMetrics.stringWidth(text);
    }

    public void setForegroundColorOverride(Color color) {
        this._foregroundNormalColor = color;
        this._foregroundSelectionColor = color;
    }

    public void setGrayedText(boolean b) {
        this._grayedText = b;
    }

    public void setGrayedSecondaryText(boolean b) {
        this._grayedSecondaryText = b;
    }

    public void setInvalid() {
    }

    public String getMainText() {
        return (String)this.getFirst(String.class);
    }

    public Icon getMainIcon() {
        return (Icon)this.getFirst(Icon.class);
    }

    public int getIconTextGap() {
        return 3;
    }

    public int getTextIconGap() {
        return 0;
    }

    public int getTextTextGap() {
        return 0;
    }

    public int getIconIconGap() {
        return 0;
    }

    public Object getFirst(Class clas) {
        Object first = null;
        for (Object o : this._elements) {
            if (!clas.isInstance(o)) continue;
            first = o;
            break;
        }
        return first;
    }

    private static int indexOfClass(List elements, Class clas) {
        int index = -1;
        for (int i = 0; i < elements.size(); ++i) {
            Object o = elements.get(0);
            if (!clas.isInstance(o)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void setMainIcon(Icon icon) {
        int index = DefaultRenderer.indexOfClass(this._elements, Icon.class);
        if (index == 0) {
            this._elements.remove(index);
        }
        if (icon != null) {
            this._elements.add(0, icon);
        }
    }

    public void setMainText(String text) {
        int index = DefaultRenderer.indexOfClass(this._elements, String.class);
        if (index == 0 || index == 1) {
            this._elements.remove(index);
        }
        this.addText(text);
    }

    public void appendIcon(Icon icon) {
        this.addIcon(icon);
    }

    public void appendText(String text) {
        this.addText(text);
    }

    public void addIcon(Icon icon) {
        if (icon != null) {
            this._elements.add(icon);
        }
    }

    public void addText(String text) {
        if (text != null) {
            this._elements.add(text);
        }
    }

    public void setNormalForegroundColor(Color color) {
        this._foregroundNormalColor = color;
    }

    protected void loadDuplicate(Object o) {
        this.load(o);
    }

    protected Component setup(Component c, Object value, boolean hasFocus, boolean isSelected) {
        this._grayedText = false;
        this._value = value;
        Font font = c.getFont();
        if (font.isBold()) {
            font = font.deriveFont(0);
        }
        this.setFont(font);
        this._hasFocus = hasFocus;
        this._isSelected = isSelected;
        this._elements.clear();
        if (value == null) {
            this.loadNull();
        } else if (value instanceof LazyTreeNode) {
            LazyTreeNode node = (LazyTreeNode)value;
            Object object = node.getUserObject();
            if (node.isDuplicate()) {
                this.loadDuplicate(object);
            } else {
                this.load(object);
            }
        } else {
            this.load(value);
        }
        this._fontMetrics = this.getFontMetrics(this.getFont());
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        if (currentLookAndFeel != this._cachedLookAndFeel) {
            this.loadTreeColors();
            this._cachedLookAndFeel = currentLookAndFeel;
            this._focusRectColor = this._cachedLookAndFeel instanceof MetalLookAndFeel ? MetalLookAndFeel.getFocusColor() : Color.GRAY;
        }
        this.checkDropTarget(c, value);
        return this;
    }

    public void clear() {
        this._elements.clear();
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public boolean isOpaque() {
        return true;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void invalidate() {
    }

    public void repaint() {
    }

    public void repaint(int x, int y, int w, int h) {
    }

    public void repaint(Rectangle r) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }
}

