/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class DeleteAction
extends AllowableAction {
    private static final long serialVersionUID = -5040421731435729618L;

    protected DeleteAction(String text, Selectable selectable, Icon icon) {
        super(text, text, icon, selectable);
    }

    protected DeleteAction(String text, Selectable selectable) {
        super(text, selectable);
        if (this.getIcon() == null) {
            this.setIcon(Icons.getDeleteIcon());
        }
    }

    protected DeleteAction(ResourceKey key, Selectable selectable) {
        super(key, selectable);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.isAllowed() && this.confirmDelete()) {
            this.onDelete();
        }
    }

    private boolean confirmDelete() {
        String text = LocalizedText.getText(ResourceKey.DIALOG_CONFIRM_DELETE_TEXT);
        int result = ModalDialog.showMessageDialog((Component)((JComponent)((Object)this.getSelectable())), text, 13);
        return result == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete() {
        WaitCursor cursor = new WaitCursor((JComponent)((Object)this.getSelectable()));
        try {
            this.onDelete(new ArrayList(this.getSelection()));
        }
        finally {
            cursor.hide();
        }
    }

    protected void onDelete(Collection items) {
        Iterator i = this.getSelection().iterator();
        while (i.hasNext()) {
            this.onDelete(i.next());
        }
    }

    public void onDelete(Object o) {
        Log.getLogger().warning("onDelete called: should have been overridden");
    }
}

