/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.DeletionHookFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.util.DeletionHook;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionHookUtil {
    public static void addDeletionHook(KnowledgeBase kb, DeletionHook hook) {
        DeletionHookFrameStore frameStore = DeletionHookUtil.getFrameStore(kb, true);
        frameStore.addHook(hook);
    }

    public static void removeDeletionHook(KnowledgeBase kb, DeletionHook hook) {
        DeletionHookFrameStore frameStore = DeletionHookUtil.getFrameStore(kb, false);
        if (frameStore != null) {
            frameStore.removeHook(hook);
        }
    }

    public static Set<DeletionHook> getHooks(KnowledgeBase kb) {
        DeletionHookFrameStore frameStore = DeletionHookUtil.getFrameStore(kb, false);
        if (frameStore == null) {
            return null;
        }
        return frameStore.getHooks();
    }

    private static DeletionHookFrameStore getFrameStore(KnowledgeBase kb, boolean create) {
        FrameStoreManager fsm = kb.getFrameStoreManager();
        DeletionHookFrameStore frameStore = fsm.getFrameStoreFromClass(DeletionHookFrameStore.class);
        if (frameStore == null) {
            int pos = kb.getProject().isMultiUserServer() ? 1 : 0;
            frameStore = new DeletionHookFrameStore();
            fsm.insertFrameStore(frameStore, pos);
        }
        return frameStore;
    }
}

