/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class DirectoryClassLoader
extends URLClassLoader {
    private File directory;
    private static FilenameFilter jarFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public DirectoryClassLoader(File directory, ClassLoader parent) {
        super(DirectoryClassLoader.getURLs(directory), parent);
        this.directory = directory;
    }

    private static URL[] getURLs(File directory) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (directory != null) {
            urls.add(FileUtilities.toURL(directory));
            File[] jarFiles = directory.listFiles(jarFilter);
            if (jarFiles != null) {
                for (int i = 0; i < jarFiles.length; ++i) {
                    File jarFile = jarFiles[i];
                    urls.add(FileUtilities.toURL(jarFile));
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public File getDirectory() {
        return this.directory;
    }

    public URL findResource(String resource) {
        URL url = null;
        File file = new File(this.directory, resource);
        if (file.exists()) {
            url = FileUtilities.toURL(file);
        }
        if (url == null) {
            url = super.findResource(resource);
        }
        return url;
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.directory + ", " + this.getParent() + ")";
    }

    public URL[] getURLs() {
        return null;
    }
}

