/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JTree;

public class DoubleClickActionAdapter
extends MouseAdapter {
    private Action _action;

    public DoubleClickActionAdapter(Action initialAction) {
        this._action = initialAction;
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2 && !event.isMetaDown() && DoubleClickActionAdapter.wantDoubleClick(event)) {
            ActionEvent actionEvent = new ActionEvent(event.getSource(), 1001, null);
            this._action.actionPerformed(actionEvent);
        }
    }

    private static boolean wantDoubleClick(MouseEvent event) {
        boolean wantDoubleClick = true;
        Object source = event.getSource();
        if (source instanceof JTree) {
            JTree tree = (JTree)source;
            Point point = event.getPoint();
            int eventLocation = tree.getRowForLocation(point.x, point.y);
            int[] rows = tree.getSelectionRows();
            if (rows != null && rows[0] != eventLocation) {
                wantDoubleClick = false;
            }
        }
        return wantDoubleClick;
    }
}

