/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFilter
extends FileFilter {
    private List<String> _extensions = new ArrayList<String>();
    private String _description;

    public ExtensionFilter(Iterator<String> extensions, String description) {
        while (extensions.hasNext()) {
            String extension = extensions.next();
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this._extensions.add(extension);
        }
        this._description = description;
    }

    public ExtensionFilter(String extension, String description) {
        this(Collections.singleton(extension).iterator(), description);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String lowerCaseName = file.getName().toLowerCase();
        for (String s : this._extensions) {
            if (!lowerCaseName.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        String es = "";
        Iterator<String> it = this._extensions.iterator();
        while (it.hasNext()) {
            String s = it.next();
            es = es + "*" + s;
            if (!it.hasNext()) continue;
            es = es + ", ";
        }
        String text = this._description == null ? es + " files " : this._description + " (" + es + ")";
        return text;
    }
}

