/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileField
extends JComponent {
    private static final long serialVersionUID = -1937723313054574468L;
    private JTextField _textField;
    private String _description;
    private String _extension;
    private ExtensionFilter _extensionFilter;
    private ChangeListener _changeListener;
    private int _fileMode;
    private int _dialogType = 0;

    public FileField(String label, String path, String extension, String description) {
        this(label, path, extension, description, 0);
    }

    public FileField(String label, String path, ExtensionFilter extensionFilter) {
        this(label, path, "", "", 0);
        this._extensionFilter = extensionFilter;
    }

    public FileField(String label, String path, String description) {
        this(label, path, "", description, 1);
    }

    public void setDialogType(int dialogType) {
        this._dialogType = dialogType;
    }

    private FileField(String label, String path, String extension, String description, int mode) {
        this._fileMode = mode;
        this._description = description;
        this._extension = extension;
        this.setLayout(new BorderLayout());
        LabeledComponent c = new LabeledComponent(label, this.createComponent(path));
        c.addHeaderButton(new AbstractAction("Browse for File", Icons.getAddIcon()){
            private static final long serialVersionUID = -784971900386531813L;

            public void actionPerformed(ActionEvent event) {
                FileField.this.browse();
            }
        });
        this.add(c);
    }

    public void addChangeListener(ChangeListener listener) {
        Assert.assertNull("existing change listener", this._changeListener);
        this._changeListener = listener;
    }

    protected void browse() {
        JFileChooser chooser = this._extensionFilter == null ? ComponentFactory.createFileChooser(this._description, this._extension) : ComponentFactory.createFileChooser(null, this._extensionFilter);
        chooser.setApproveButtonText("Select");
        chooser.setFileSelectionMode(this._fileMode);
        chooser.setDialogType(this._dialogType);
        int dialogResult = chooser.showDialog(this, "Select");
        switch (dialogResult) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this._textField.setText(chooser.getSelectedFile().getPath());
                break;
            }
            default: {
                Assert.fail("bad result: " + dialogResult);
            }
        }
    }

    private JComponent createComponent(String text) {
        this._textField = ComponentFactory.createTextField();
        this._textField.setColumns(40);
        if ((text == null || text.length() == 0) && this._fileMode == 1) {
            text = SystemUtilities.getUserDirectory();
        }
        this._textField.setText(text);
        this._textField.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent event) {
                FileField.this.notifyListener();
            }
        });
        return this._textField;
    }

    public String getPath() {
        String text = this._textField.getText();
        if (text.length() == 0) {
            text = null;
        } else {
            try {
                text = new File(text).getAbsolutePath();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return text;
    }

    public File getFilePath() {
        String path = this.getPath();
        return path == null ? null : new File(path);
    }

    private void notifyListener() {
        if (this._changeListener != null) {
            this._changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setPath(String text) {
        this._textField.setText(text);
    }
}

