/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AbstractSelectableComponent;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;

public class FileList
extends AbstractSelectableComponent {
    private static final long serialVersionUID = -2010583722771917590L;
    private JList _fileList;
    private String _description;
    private String _extension;

    public FileList(String label, Collection files, String extension, String description) {
        this._description = description;
        this._extension = extension;
        this.setLayout(new BorderLayout());
        LabeledComponent c = new LabeledComponent(label, this.createComponent(files));
        c.addHeaderButton(this.newAddAction());
        c.addHeaderButton(this.newRemoveAction());
        this.add(c);
        this.setPreferredSize(new Dimension(300, 200));
    }

    private void browse() {
        JFileChooser chooser = ComponentFactory.createFileChooser(this._description, this._extension);
        chooser.setMultiSelectionEnabled(true);
        int openDialogResult = chooser.showOpenDialog(this);
        switch (openDialogResult) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                File[] files = chooser.getSelectedFiles();
                if (files == null) break;
                for (int i = 0; i < files.length; ++i) {
                    ComponentUtilities.addSelectedListValue(this._fileList, files[i].getPath());
                }
                break;
            }
            default: {
                Assert.fail("bad result: " + openDialogResult);
            }
        }
    }

    public void clearSelection() {
        this._fileList.clearSelection();
    }

    private JComponent createComponent(Collection files) {
        this._fileList = ComponentFactory.createList(this.newAddAction());
        this._fileList.addListSelectionListener(new ListSelectionListenerAdapter(this));
        if (files != null) {
            ComponentUtilities.setListValues(this._fileList, files);
        }
        return ComponentFactory.createScrollPane(this._fileList);
    }

    public Collection getPaths() {
        return ComponentUtilities.getListValues(this._fileList);
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._fileList);
    }

    private Action newAddAction() {
        return new AddAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = -4235411306185033490L;

            public void onAdd() {
                FileList.this.browse();
            }
        };
    }

    private Action newRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -7910730547550960702L;

            public void onRemove(Collection values) {
                ComponentUtilities.removeListValues(FileList.this._fileList, values);
            }
        };
    }
}

