/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameWithBrowserText
implements Serializable,
Localizable {
    private static final long serialVersionUID = -8597023478383674378L;
    private Frame frame;
    private String browserText;
    private Collection<Cls> types;
    private String iconName;

    public FrameWithBrowserText(Frame frame) {
        this(frame, null);
    }

    public FrameWithBrowserText(Frame frame, String browserText) {
        this(frame, browserText, null, null);
    }

    public FrameWithBrowserText(Frame frame, String browserText, Collection<Cls> types) {
        this(frame, browserText, types, null);
    }

    public FrameWithBrowserText(Frame frame, String browserText, Collection<Cls> types, String iconName) {
        this.frame = frame;
        this.browserText = browserText == null ? frame.getName() : browserText;
        this.types = types == null ? new ArrayList() : types;
        this.iconName = iconName;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public String getBrowserText() {
        return this.browserText;
    }

    public void setBrowserText(String browserText) {
        this.browserText = browserText;
    }

    public Collection<Cls> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<Cls> types) {
        this.types = types;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    @Override
    public void localize(KnowledgeBase kb) {
        LocalizeUtils.localize(this.frame, kb);
        LocalizeUtils.localize(this.types, kb);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FrameWithBrowserText)) {
            return false;
        }
        FrameWithBrowserText fbt = (FrameWithBrowserText)obj;
        return fbt.getFrame() == null ? false : fbt.getFrame().equals(this.frame);
    }

    public int hashCode() {
        return this.frame == null ? 42 : this.frame.getName().length() * 43 + this.frame.getName().hashCode();
    }

    public static Collection<FrameWithBrowserText> getFramesWithBrowserText(Collection<? extends Frame> frames) {
        if (frames == null) {
            return null;
        }
        ArrayList<FrameWithBrowserText> fbts = new ArrayList<FrameWithBrowserText>();
        for (Frame frame : frames) {
            FrameWithBrowserText fbt = FrameWithBrowserText.getFrameWithBrowserText(frame);
            if (fbt == null) continue;
            fbts.add(fbt);
        }
        return fbts;
    }

    public static FrameWithBrowserText getFrameWithBrowserText(Frame frame) {
        if (frame == null) {
            return null;
        }
        return new FrameWithBrowserText(frame, frame.getBrowserText(), frame instanceof Instance ? ((Instance)frame).getDirectTypes() : null);
    }

    public static Collection<Frame> getFrames(Collection<FrameWithBrowserText> framesWithBrowserText) {
        if (framesWithBrowserText == null) {
            return null;
        }
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (FrameWithBrowserText fbt : framesWithBrowserText) {
            Frame frame = fbt.getFrame();
            if (frame == null) continue;
            frames.add(frame);
        }
        return frames;
    }
}

