/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.ProjectFixupPlugin;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Frames1_8_BackwardsCompatibilityProjectFixups
implements ProjectFixupPlugin {
    private static final String MIN_VERSION = "1.9";

    private static void addWidgetDescriptor(Instance formWidgetInstance, String slotName) {
        Instance propertyList = (Instance)ModelUtilities.getDirectOwnSlotValue(formWidgetInstance, "property_list");
        Iterator i = ModelUtilities.getDirectOwnSlotValues(propertyList, "properties").iterator();
        boolean foundIt = false;
        while (i.hasNext() && !foundIt) {
            Instance instance = (Instance)i.next();
            String name = (String)ModelUtilities.getDirectOwnSlotValue(instance, "name");
            if (!name.equals(slotName)) continue;
            foundIt = true;
        }
        if (!foundIt) {
            KnowledgeBase kb = formWidgetInstance.getKnowledgeBase();
            WidgetDescriptor d = WidgetDescriptor.create(kb);
            ModelUtilities.setOwnSlotValue(d.getInstance(), "name", slotName);
            ModelUtilities.addOwnSlotValue(propertyList, "properties", d.getInstance());
        }
    }

    public static void fix(KnowledgeBase kb) {
        if (Frames1_8_BackwardsCompatibilityProjectFixups.shouldUpdate(kb)) {
            Log.getLogger().info("Backwards compatibility fixup for frames project file");
            Frames1_8_BackwardsCompatibilityProjectFixups.updateStandardForms(kb);
        }
    }

    private static boolean shouldUpdate(KnowledgeBase kb) {
        return !Frames1_8_BackwardsCompatibilityProjectFixups.isCurrentBuild(kb) && !Frames1_8_BackwardsCompatibilityProjectFixups.isOwl(kb);
    }

    private static boolean isOwl(KnowledgeBase kb) {
        Slot slot;
        Instance instance = kb.getInstance("PROJECT");
        String value = (String)instance.getOwnSlotValue(slot = kb.getSlot("default_cls_metaclass"));
        return value.contains("owl:") || value.contains("/owl#");
    }

    private static Instance getClsWidgetInstance(String name, KnowledgeBase kb) {
        Instance result = null;
        List values = ModelUtilities.getDirectOwnSlotValues(Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(kb), "customized_instance_widgets");
        for (Instance widgetInstance : values) {
            String widgetSlotName = (String)ModelUtilities.getDirectOwnSlotValue(widgetInstance, "name");
            if (!name.equals(widgetSlotName)) continue;
            result = widgetInstance;
            break;
        }
        return result;
    }

    private static KnowledgeBaseFactory getFactory(KnowledgeBase kb) {
        KnowledgeBaseFactory result = null;
        Instance projectInstance = Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(kb);
        Instance sources = (Instance)ModelUtilities.getDirectOwnSlotValue(projectInstance, "sources");
        for (Instance property : ModelUtilities.getDirectOwnSlotValues(sources, "properties")) {
            String name = (String)ModelUtilities.getDirectOwnSlotValue(property, "name");
            if (!name.equals("factory_class_name")) continue;
            String factoryName = (String)ModelUtilities.getDirectOwnSlotValue(property, "string_value");
            result = (KnowledgeBaseFactory)SystemUtilities.newInstance(factoryName);
            break;
        }
        return result;
    }

    private static Instance getProjectInstance(KnowledgeBase kb) {
        Instance instance = kb.getInstance("PROJECT");
        Assert.assertNotNull("instance", instance);
        return instance;
    }

    private static KnowledgeBase getTemplateKnowledgeBase(KnowledgeBase projectKB) {
        ArrayList errors = new ArrayList();
        Reader clsesReader = Files.getSystemClsesReader();
        KnowledgeBaseFactory factory = Frames1_8_BackwardsCompatibilityProjectFixups.getFactory(projectKB);
        String path = factory == null ? (String)null : factory.getProjectFilePath();
        Reader instancesReader = path == null ? Files.getSystemInstancesReader() : FileUtilities.getResourceReader(factory.getClass(), path);
        return new ClipsKnowledgeBaseFactory().loadKnowledgeBase(clsesReader, instancesReader, errors);
    }

    private static boolean isClsMetaclass(Instance formWidgetInstance) {
        boolean result = false;
        Instance propertyListInstance = (Instance)ModelUtilities.getDirectOwnSlotValue(formWidgetInstance, "property_list");
        for (Instance slotWidgetInstance : ModelUtilities.getDirectOwnSlotValues(propertyListInstance, "properties")) {
            String slotName = (String)ModelUtilities.getDirectOwnSlotValue(slotWidgetInstance, "name");
            if (!slotName.equals(":DIRECT-TEMPLATE-SLOTS")) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isCurrentBuild(KnowledgeBase kb) {
        String currentVersion = Text.getVersion();
        String kbBuild = kb.getBuildString();
        return kbBuild == null || currentVersion.compareTo(MIN_VERSION) >= 0;
    }

    private static boolean isSlotMetaclass(Instance formWidgetInstance) {
        boolean result = false;
        Instance propertyListInstance = (Instance)ModelUtilities.getDirectOwnSlotValue(formWidgetInstance, "property_list");
        for (Instance slotWidgetInstance : ModelUtilities.getDirectOwnSlotValues(propertyListInstance, "properties")) {
            String slotName = (String)ModelUtilities.getDirectOwnSlotValue(slotWidgetInstance, "name");
            if (!slotName.equals(":SLOT-VALUE-TYPE")) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean replaceFormWidget(String name, KnowledgeBase projectKB, KnowledgeBase templateProjectKB) {
        Instance templateClsWidget = Frames1_8_BackwardsCompatibilityProjectFixups.getClsWidgetInstance(name, templateProjectKB);
        Instance projectClsWidget = Frames1_8_BackwardsCompatibilityProjectFixups.getClsWidgetInstance(name, projectKB);
        if (projectClsWidget == null) {
            Cls widgetCls = projectKB.getCls("Widget");
            projectClsWidget = projectKB.createInstance(null, widgetCls);
            ModelUtilities.setOwnSlotValue(projectClsWidget, "name", name);
            Instance projectInstance = Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(projectKB);
            ModelUtilities.addOwnSlotValue(projectInstance, "customized_instance_widgets", projectClsWidget);
        }
        Instance templatePropertyList = (Instance)ModelUtilities.getDirectOwnSlotValue(templateClsWidget, "property_list");
        Instance newPropertyList = (Instance)templatePropertyList.deepCopy(projectKB, null);
        ModelUtilities.setOwnSlotValue(projectClsWidget, "property_list", newPropertyList);
        return templateClsWidget != null;
    }

    private static void updateStandardForms(KnowledgeBase projectKB) {
        KnowledgeBase templateProjectKB = Frames1_8_BackwardsCompatibilityProjectFixups.getTemplateKnowledgeBase(projectKB);
        Instance templateProjectInstance = Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(templateProjectKB);
        for (Instance widgetInstance : ModelUtilities.getDirectOwnSlotValues(templateProjectInstance, "customized_instance_widgets")) {
            String widgetClsName = (String)ModelUtilities.getDirectOwnSlotValue(widgetInstance, "name");
            boolean changed = Frames1_8_BackwardsCompatibilityProjectFixups.replaceFormWidget(widgetClsName, projectKB, templateProjectKB);
            if (changed) continue;
            if (Frames1_8_BackwardsCompatibilityProjectFixups.isClsMetaclass(widgetInstance)) {
                Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":DIRECT-TYPE");
                continue;
            }
            if (!Frames1_8_BackwardsCompatibilityProjectFixups.isSlotMetaclass(widgetInstance)) continue;
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":DIRECT-TEMPLATE-SLOTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":SLOT-CONSTRAINTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":DIRECT-SUBSLOTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":DIRECT-SUPERSLOTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":DIRECT-DOMAIN");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":SLOT-INVERSE");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":SLOT-VALUES");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":SLOT-MINIMUM-CARDINALITY");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(widgetInstance, ":ASSOCIATED-FACET");
        }
    }

    public void fixProject(KnowledgeBase internalKB) {
        Frames1_8_BackwardsCompatibilityProjectFixups.fix(internalKB);
    }

    public String getName() {
        return "Frames 1.8 Project Backwards Compatibility Fix";
    }

    public void dispose() {
    }
}

