/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.FrameWithBrowserTextComparator;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInstancesAndBrowserTextJob
extends ProtegeJob {
    private static final long serialVersionUID = 2958930580121193877L;
    private Collection<Cls> clses;
    private boolean directInstances = true;

    public GetInstancesAndBrowserTextJob(KnowledgeBase kb, Collection<Cls> clses, boolean directInstances) {
        super(kb);
        this.clses = clses;
        this.directInstances = directInstances;
    }

    @Override
    public Collection<FrameWithBrowserText> run() throws ProtegeException {
        ArrayList<FrameWithBrowserText> framesWithBrowserText = new ArrayList<FrameWithBrowserText>();
        for (Cls cls : this.clses) {
            Collection<Instance> instances = this.directInstances ? cls.getDirectInstances() : cls.getInstances();
            for (Instance instance : instances) {
                framesWithBrowserText.add(new FrameWithBrowserText(instance, instance.getBrowserText(), instance.getDirectTypes()));
            }
            this.addRequestsToFrameCalculator(instances);
        }
        Collections.sort(framesWithBrowserText, new FrameWithBrowserTextComparator());
        return framesWithBrowserText;
    }

    private void addRequestsToFrameCalculator(Collection<Instance> instances) {
        if (!this.getKnowledgeBase().getProject().isMultiUserServer()) {
            return;
        }
        Server server = Server.getInstance();
        RemoteSession session = ServerFrameStore.getCurrentSession();
        ServerProject serverProject = server.getServerProject(this.getKnowledgeBase().getProject());
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(session);
        FrameCalculator fc = serverFrameStore.getFrameCalculator();
        for (Instance instance : instances) {
            fc.addRequest(instance, session, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        }
    }

    @Override
    public Collection<FrameWithBrowserText> execute() throws ProtegeException {
        return (Collection)super.execute();
    }

    @Override
    public void localize(KnowledgeBase kb) {
        super.localize(kb);
        LocalizeUtils.localize(this.clses, kb);
    }
}

