/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.FrameWithBrowserTextComparator;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetOwnSlotValuesBrowserTextJob
extends ProtegeJob {
    private static final long serialVersionUID = 2958930580121193877L;
    protected Frame frame;
    protected Slot slot;
    protected boolean directValues = false;

    public GetOwnSlotValuesBrowserTextJob(KnowledgeBase kb, Frame frame, Slot slot, boolean directValues) {
        super(kb);
        this.frame = frame;
        this.slot = slot;
        this.directValues = directValues;
    }

    @Override
    public Collection<FrameWithBrowserText> run() throws ProtegeException {
        ArrayList<FrameWithBrowserText> framesWithBrowserText = new ArrayList<FrameWithBrowserText>();
        this.addRequestsToFrameCalculator(this.frame);
        Collection values = this.getValues();
        for (Object value : values) {
            if (value instanceof Frame) {
                Frame valueFrame = (Frame)value;
                framesWithBrowserText.add(new FrameWithBrowserText(valueFrame, valueFrame.getBrowserText(), ((Instance)valueFrame).getDirectTypes()));
                this.addRequestsToFrameCalculator(valueFrame);
                continue;
            }
            framesWithBrowserText.add(new FrameWithBrowserText(null, value.toString(), null));
        }
        Collections.sort(framesWithBrowserText, new FrameWithBrowserTextComparator());
        return framesWithBrowserText;
    }

    protected Collection getValues() {
        return this.directValues ? this.frame.getDirectOwnSlotValues(this.slot) : this.frame.getOwnSlotValues(this.slot);
    }

    private void addRequestsToFrameCalculator(Frame frm) {
        if (!this.getKnowledgeBase().getProject().isMultiUserServer()) {
            return;
        }
        Server server = Server.getInstance();
        RemoteSession session = ServerFrameStore.getCurrentSession();
        ServerProject serverProject = server.getServerProject(this.getKnowledgeBase().getProject());
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(session);
        FrameCalculator fc = serverFrameStore.getFrameCalculator();
        fc.addRequest(frm, session, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
    }

    @Override
    public Collection<FrameWithBrowserText> execute() throws ProtegeException {
        return (Collection)super.execute();
    }

    @Override
    public void localize(KnowledgeBase kb) {
        super.localize(kb);
        LocalizeUtils.localize(this.frame, kb);
        LocalizeUtils.localize(this.slot, kb);
    }
}

