/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class HashList
extends AbstractSequentialList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8024066403796069628L;
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private Map _valueEntryMap = new HashMap();
    private List _unmodifiableList;

    public HashList() {
        this.header.next = this.header.previous = this.header;
    }

    public HashList(Collection c) {
        this();
        this.addAll(c);
    }

    public void add(int index, Object element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index));
    }

    public boolean add(Object o) {
        this.addBefore(o, this.header);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        ++this.modCount;
        Entry successor = index == this.size ? this.header : this.entry(index);
        Entry predecessor = successor.previous;
        Iterator it = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            Entry e;
            predecessor.next = e = this.newEntry(it.next(), successor, predecessor);
            predecessor = e;
        }
        successor.previous = predecessor;
        this.size += numNew;
        return true;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    private Entry addBefore(Object o, Entry e) {
        Entry newEntry;
        newEntry.previous.next = newEntry = this.newEntry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        return newEntry;
    }

    public void addFirst(Object o) {
        this.addBefore(o, this.header.next);
    }

    private void addHashEntry(Entry e) {
        Object o = e.element;
        Object entryOrList = this._valueEntryMap.get(o);
        if (entryOrList == null) {
            this._valueEntryMap.put(o, e);
        } else if (entryOrList instanceof List) {
            ((List)entryOrList).add(e);
        } else {
            ArrayList<Object> c = new ArrayList<Object>();
            c.add(entryOrList);
            c.add(e);
            this._valueEntryMap.put(o, c);
        }
    }

    public void addLast(Object o) {
        this.addBefore(o, this.header);
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this._valueEntryMap.clear();
        this.size = 0;
    }

    public Object clone() {
        return new LinkedList(this);
    }

    public boolean contains(Object o) {
        return this.containsHashKey(o);
    }

    private boolean containsHashKey(Object o) {
        return this._valueEntryMap.containsKey(o);
    }

    private Entry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    public Object get(int index) {
        return this.entry((int)index).element;
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    private Entry getFirstHashEntry(Object o) {
        Entry entry;
        Object entryOrList = this._valueEntryMap.get(o);
        if (entryOrList == null) {
            entry = null;
        } else if (entryOrList instanceof List) {
            List c = (List)entryOrList;
            entry = (Entry)c.get(0);
        } else {
            entry = (Entry)entryOrList;
        }
        return entry;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    private int getModCount() {
        return this.modCount;
    }

    public List getUnmodifiableList() {
        if (this._unmodifiableList == null) {
            this._unmodifiableList = Collections.unmodifiableList(this);
        }
        return this._unmodifiableList;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            Entry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (e.element == null) {
                    return index;
                }
                e = e.previous;
            }
        } else {
            Entry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (o.equals(e.element)) {
                    return index;
                }
                e = e.previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    private Entry newEntry(Object element, Entry next, Entry previous) {
        Entry entry = new Entry(element, next, previous);
        this.addHashEntry(entry);
        return entry;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int objects = s.readInt();
        this.header.next = this.header.previous = (this.header = this.newEntry(null, null, null));
        for (int i = 0; i < objects; ++i) {
            this.add(s.readObject());
        }
    }

    public Object remove(int index) {
        Entry e = this.entry(index);
        this.remove(e);
        return e.element;
    }

    private void remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
        ++this.modCount;
        this.removeHashEntry(e);
    }

    public boolean remove(Object o) {
        boolean succeeded;
        Entry e = this.getFirstHashEntry(o);
        if (e == null) {
            succeeded = false;
        } else {
            this.remove(e);
            succeeded = true;
        }
        return succeeded;
    }

    public Object removeFirst() {
        Object first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    private void removeHashEntry(Entry entry) {
        Object o = entry.element;
        Object entryOrList = this._valueEntryMap.get(o);
        if (entryOrList == null) {
            Log.getLogger().warning("unable to remove: " + o);
        } else if (entryOrList instanceof List) {
            List c = (List)entryOrList;
            c.remove(entry);
            if (c.size() == 1) {
                this._valueEntryMap.put(o, c.get(0));
            }
        } else {
            Entry e = (Entry)entryOrList;
            Assert.assertSame("entry", e.element, o);
            this._valueEntryMap.remove(o);
        }
    }

    private Entry removeHashEntry(Object o) {
        Entry entry = this.getFirstHashEntry(o);
        this.removeHashEntry(entry);
        return entry;
    }

    public Object removeLast() {
        Object last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    public void replace(int index, Object to) {
        Entry entry = this.entry(index);
        this.removeHashEntry(entry);
        entry.element = to;
        this.addHashEntry(entry);
    }

    public void replace(Object from, Object to) {
        Entry entry = this.removeHashEntry(from);
        entry.element = to;
        this.addHashEntry(entry);
    }

    public Object set(int index, Object element) {
        Entry e = this.entry(index);
        Object oldVal = e.element;
        e.element = element;
        this.addHashEntry(e);
        return oldVal;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            a[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public String toString() {
        return "HashList";
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Entry e = this.header.next;
        while (e != this.header) {
            s.writeObject(e.element);
            e = e.next;
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = -2080231082256914843L;
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.lastReturned = HashList.this.header;
            this.expectedModCount = HashList.this.getModCount();
            if (index < 0 || index > HashList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + HashList.this.size);
            }
            if (index < HashList.this.size / 2) {
                this.next = ((HashList)HashList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = HashList.this.header;
                this.nextIndex = HashList.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        public boolean hasNext() {
            return this.nextIndex != HashList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == HashList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            HashList.this.remove(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = HashList.this.header;
            ++this.expectedModCount;
        }

        public void set(Object o) {
            if (this.lastReturned == HashList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            HashList.this.removeHashEntry(this.lastReturned);
            this.lastReturned.element = o;
            HashList.this.addHashEntry(this.lastReturned);
        }

        public void add(Object o) {
            this.checkForComodification();
            this.lastReturned = HashList.this.header;
            HashList.this.addBefore(o, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (HashList.this.getModCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

