/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.util.Assert;
import java.awt.Dimension;
import java.awt.Rectangle;

public class InstanceUtilities {
    private static final String CLASS_DIMENSION = "Dimension";
    private static final String SLOT_X = "x";
    private static final String SLOT_Y = "y";
    private static final String SLOT_WIDTH = "width";
    private static final String SLOT_HEIGHT = "height";

    public static Dimension getDimension(Instance instance) {
        Assert.assertEquals("class name", instance.getDirectType().getName(), CLASS_DIMENSION);
        Dimension d = new Dimension();
        d.width = InstanceUtilities.getInt(instance, SLOT_WIDTH);
        d.height = InstanceUtilities.getInt(instance, SLOT_HEIGHT);
        return d;
    }

    private static int getInt(Instance instance, String name) {
        Object o = ModelUtilities.getDirectOwnSlotValue(instance, name);
        Integer i = o instanceof String ? new Integer((String)o) : (Integer)o;
        return i == null ? 0 : i;
    }

    public static Rectangle getRectangle(Instance instance) {
        Rectangle r = new Rectangle();
        r.x = InstanceUtilities.getInt(instance, SLOT_X);
        r.y = InstanceUtilities.getInt(instance, SLOT_Y);
        r.width = InstanceUtilities.getInt(instance, SLOT_WIDTH);
        r.height = InstanceUtilities.getInt(instance, SLOT_HEIGHT);
        return r;
    }

    public static void setDimension(Instance instance, Dimension d) {
        Assert.assertEquals("class name", instance.getDirectType().getName(), CLASS_DIMENSION);
        InstanceUtilities.setInt(instance, SLOT_WIDTH, d.width);
        InstanceUtilities.setInt(instance, SLOT_HEIGHT, d.height);
    }

    private static void setInt(Instance instance, String name, int i) {
        ModelUtilities.setOwnSlotValue(instance, name, new Integer(i));
    }

    public static void setRectangle(Instance instance, Rectangle r) {
        InstanceUtilities.setInt(instance, SLOT_X, r.x);
        InstanceUtilities.setInt(instance, SLOT_Y, r.y);
        InstanceUtilities.setInt(instance, SLOT_WIDTH, r.width);
        InstanceUtilities.setInt(instance, SLOT_HEIGHT, r.height);
    }
}

