/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;

public class IntegerField
extends JComponent {
    private static final long serialVersionUID = 6434174131636406043L;
    private ActionListener itsActionListener;
    private JTextField _textField;
    private JLabel _label;

    public IntegerField(String text) {
        this.setLayout(new BorderLayout());
        this._label = ComponentFactory.createLabel(text);
        this._label.setForeground(UIManager.getColor("Checkbox.foreground"));
        this.createTextField();
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)this._label, "West");
        north.add((Component)this._textField, "Center");
        this.add((Component)north, "North");
    }

    public void addActionListener(ActionListener listener) {
        this.itsActionListener = listener;
    }

    public void clearValue() {
        this._textField.setText("");
    }

    private JComponent createTextField() {
        this._textField = ComponentFactory.createTextField();
        this._textField.setHorizontalAlignment(4);
        this._textField.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent event) {
                IntegerField.this.notifyChanged();
            }
        });
        this._textField.setColumns(3);
        return this._textField;
    }

    public Integer getValue() {
        Integer i;
        try {
            String s = this._textField.getText();
            i = new Integer(s);
        }
        catch (NumberFormatException e) {
            i = null;
        }
        return i;
    }

    private void notifyChanged() {
        if (this.itsActionListener != null) {
            this.itsActionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.itsActionListener = null;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this._textField.setEnabled(b);
        this._label.setEnabled(b);
    }

    public void setValue(int i) {
        this._textField.setText(String.valueOf(i));
        this._textField.repaint();
    }
}

