/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledComponent
extends JComponent {
    private static final long serialVersionUID = 5999709474215501024L;
    private List<Action> actions = new ArrayList<Action>();
    private JComponent _header;
    private JToolBar _toolBar;
    private JLabel _label;
    private JComponent _headerComponentHolder;
    private JComponent _centerComponentHolder;
    private JComponent _footerComponentHolder;
    private boolean _isVerticallyStretchable;
    private boolean _isSwapedHeader;

    public LabeledComponent(String label, Component c) {
        this(label, c, c instanceof JScrollPane);
    }

    public LabeledComponent(String label, Component c, boolean verticallyStretchable) {
        this(label, c, verticallyStretchable, false);
    }

    public LabeledComponent(String label, Component c, boolean verticallyStretchable, boolean swapedHeader) {
        this._isSwapedHeader = swapedHeader;
        this._isVerticallyStretchable = verticallyStretchable || c instanceof JScrollPane;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createHeader(), "North");
        this.add((Component)this.createCenterComponentHolder(), "Center");
        this.add((Component)this.createFooterComponentHolder(), "South");
        this.setHeaderLabel(label);
        this.setCenterComponent(c);
    }

    public LabeledComponent(String label, JScrollPane c) {
        this(label, c, true);
    }

    public JButton addHeaderButton(Action action) {
        JButton button = null;
        if (action != null) {
            this.actions.add(action);
            button = ComponentFactory.addToolBarButton(this._toolBar, action);
        }
        return button;
    }

    public void addHeaderSeparator() {
        this._toolBar.addSeparator();
    }

    public JToggleButton addHeaderToggleButton(Action action) {
        JToggleButton button = null;
        if (action != null) {
            this.actions.add(action);
            button = ComponentFactory.addToggleToolBarButton(this._toolBar, action);
        }
        return button;
    }

    private JComponent createCenterComponentHolder() {
        this._centerComponentHolder = new JPanel();
        this._centerComponentHolder.setLayout(new BorderLayout());
        return this._centerComponentHolder;
    }

    private JComponent createFooterComponentHolder() {
        this._footerComponentHolder = new JPanel();
        this._footerComponentHolder.setLayout(new BorderLayout());
        return this._footerComponentHolder;
    }

    private JComponent createHeader() {
        this._header = new JPanel(){
            private static final long serialVersionUID = 7429097535969923450L;

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = Math.max(d.height, 25);
                return d;
            }
        };
        this._header.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createHeaderLabel(), this._isSwapedHeader ? "East" : "West");
        panel.add((Component)this.createHeaderComponentHolder(), "Center");
        this._header.add((Component)panel, "Center");
        this._header.add((Component)this.createHeaderToolbar(), this._isSwapedHeader ? "West" : "East");
        return this._header;
    }

    private JComponent createHeaderComponentHolder() {
        this._headerComponentHolder = new JPanel();
        this._headerComponentHolder.setLayout(new BorderLayout());
        return this._headerComponentHolder;
    }

    private JComponent createHeaderLabel() {
        this._label = ComponentFactory.createLabel();
        ComponentUtilities.setSmallLabelFont(this._label);
        this._label.setBorder(BorderFactory.createEmptyBorder(0, 4, 2, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._label, "South");
        return panel;
    }

    private JComponent createHeaderToolbar() {
        this._toolBar = ComponentFactory.createToolBar();
        return this._toolBar;
    }

    public Component getCenterComponent() {
        int count = this._centerComponentHolder.getComponentCount();
        Component component = count == 0 ? null : this._centerComponentHolder.getComponent(0);
        return component;
    }

    public Component getFooterComponent() {
        int count = this._footerComponentHolder.getComponentCount();
        return count == 0 ? (Component)null : this._footerComponentHolder.getComponent(0);
    }

    public Collection<Action> getHeaderButtonActions() {
        return Collections.unmodifiableCollection(this.actions);
    }

    public Collection getHeaderButtons() {
        ArrayList<Component> buttons = new ArrayList<Component>();
        for (int i = 0; i < this._toolBar.getComponentCount(); ++i) {
            Component c = this._toolBar.getComponent(i);
            if (!(c instanceof AbstractButton)) continue;
            buttons.add(c);
        }
        return buttons;
    }

    public boolean hasHeaderButton(Icon icon) {
        boolean hasHeaderButton = false;
        for (AbstractButton button : this.getHeaderButtons()) {
            if (!button.getIcon().equals(icon)) continue;
            hasHeaderButton = true;
            break;
        }
        return hasHeaderButton;
    }

    public Component getHeaderComponent() {
        int count = this._headerComponentHolder.getComponentCount();
        return count == 0 ? (Component)null : this._headerComponentHolder.getComponent(0);
    }

    public String getHeaderLabel() {
        return this._label.getText();
    }

    public void setComponentsEnabled(boolean b) {
        this._label.setEnabled(b);
        this.getCenterComponent().setEnabled(b);
        this._toolBar.setEnabled(b);
    }

    public boolean isVerticallyStretchable() {
        return this._isVerticallyStretchable;
    }

    public boolean isSwapedHeader() {
        return this._isSwapedHeader;
    }

    public void removeHeaderButton(int index) {
        int buttonIndex = -1;
        for (int i = 0; i < this._toolBar.getComponentCount(); ++i) {
            Component c = this._toolBar.getComponent(i);
            if (!(c instanceof AbstractButton) || ++buttonIndex != index) continue;
            this._toolBar.remove(c);
            break;
        }
    }

    public void removeAllHeaderButtons() {
        this._toolBar.removeAll();
    }

    public void setCenterComponent(Component c) {
        this._centerComponentHolder.removeAll();
        if (c != null) {
            String location = this._isVerticallyStretchable ? "Center" : "North";
            this._centerComponentHolder.add(c, location);
        }
        this.revalidate();
        this.repaint();
    }

    public void setFooterComponent(JComponent c) {
        this._footerComponentHolder.removeAll();
        if (c != null) {
            this._footerComponentHolder.add(c);
        }
    }

    public void setHeaderComponent(JComponent component) {
        this.setHeaderComponent(component, "Center");
    }

    public void setHeaderComponent(JComponent component, String alignment) {
        this._headerComponentHolder.removeAll();
        if (component == null) {
            this._headerComponentHolder.setBorder(null);
        } else {
            this._headerComponentHolder.add((Component)component, alignment);
            this._headerComponentHolder.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        }
    }

    public void setHeaderIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.adjustToolTipText();
    }

    private void adjustToolTipText() {
        if (this._header.getPreferredSize().width > this._header.getSize().width) {
            if (this._label.getToolTipText() == null) {
                this._label.setToolTipText(this._label.getText());
            }
        } else {
            this._label.setToolTipText(null);
        }
    }

    public void setHeaderLabel(String label) {
        this._label.setText(label);
        this._label.setVisible(label != null);
    }

    public void setVerticallyStretchable(boolean b) {
        if (b != this._isVerticallyStretchable) {
            this._isVerticallyStretchable = b;
            this.setCenterComponent(this.getCenterComponent());
        }
    }
}

