/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class LazyTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -1631559401681910463L;

    public LazyTreeModel() {
        this(null);
    }

    public LazyTreeModel(LazyTreeRoot root) {
        super(root == null ? new EmptyRoot() : root);
        this.getLazyTreeRoot().setModel(this);
    }

    public void dispose() {
        this.removeRoot();
    }

    private LazyTreeRoot getLazyTreeRoot() {
        return (LazyTreeRoot)this.getRoot();
    }

    private void removeRoot() {
        this.getLazyTreeRoot().dispose();
    }

    public void setRoot(TreeNode root) {
        if (root == null) {
            root = new EmptyRoot();
        }
        this.removeRoot();
        super.setRoot(root);
        if (root instanceof LazyTreeRoot) {
            ((LazyTreeRoot)root).setModel(this);
        } else {
            Log.getLogger().severe("LazyTreeeModel requires LazyTreeRoot");
        }
    }

    private static class EmptyRoot
    extends LazyTreeRoot {
        EmptyRoot() {
            super(Collections.EMPTY_LIST);
        }

        public LazyTreeNode createNode(Object o) {
            Assert.fail("no override");
            return null;
        }

        public Comparator getComparator() {
            return null;
        }
    }
}

