/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.ErrorLazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;

public abstract class LazyTreeNode
implements TreeNode {
    private LazyTreeNode _parent;
    private Object _userObject;
    private List _childNodes;
    private int _childCount = -1;
    private boolean _isLoaded;
    private boolean _isDuplicate;
    private boolean _isSorted = false;

    protected LazyTreeNode(LazyTreeNode parent, Object userObject) {
        this(parent, userObject, false);
    }

    protected LazyTreeNode(LazyTreeNode parent, Object userObject, boolean isSorted) {
        this._parent = parent;
        this._userObject = userObject;
        this._isDuplicate = LazyTreeNode.isDuplicate(userObject, parent);
        this._isSorted = isSorted;
    }

    private static boolean isDuplicate(Object userObject, LazyTreeNode parent) {
        boolean isDuplicate = false;
        for (LazyTreeNode ancestor = parent; ancestor != null; ancestor = ancestor.getLazyTreeNodeParent()) {
            if (!ancestor.getUserObject().equals(userObject)) continue;
            isDuplicate = true;
            break;
        }
        return isDuplicate;
    }

    public boolean isDuplicate() {
        return this._isDuplicate;
    }

    public void childAdded(Object o) {
        int index = this._isLoaded ? this._childNodes.size() : -1;
        this.childAdded(o, index);
    }

    private int getAddToIndex(Object o) {
        if (!this._isLoaded) {
            return -1;
        }
        if (!this._isSorted) {
            return this._childNodes.size();
        }
        return this.getSortedAddIndex(o);
    }

    private int getSortedAddIndex(Object o) {
        if (this._childNodes == null) {
            return -1;
        }
        int nChildren = this._childNodes.size();
        int index = -1;
        for (int i = 0; i < nChildren; ++i) {
            LazyTreeNode node = (LazyTreeNode)this._childNodes.get(i);
            if (this.compareTo(node.getUserObject(), o) <= 0) continue;
            return i;
        }
        return nChildren;
    }

    protected int compareTo(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return o1 == null ? 0 : 1;
        }
        if (o1 instanceof Frame) {
            return o2 instanceof Frame ? ((Frame)o1).compareTo((Frame)o2) : ((Frame)o1).getBrowserText().compareTo(o2.toString());
        }
        return o1.toString().compareTo(o2.toString());
    }

    public void childAdded(Object o, int index) {
        if (this._isLoaded) {
            int ti = this.getIndex(o);
            if (ti != -1) {
                LazyTreeNode child = (LazyTreeNode)this._childNodes.get(ti);
                this.notifyChildNodeAdded(this, ti, child);
            } else {
                LazyTreeNode child = this.createNode(o);
                this._childNodes.add(index, child);
                ++this._childCount;
                this.notifyChildNodeAdded(this, index, child);
            }
        } else {
            this.ensureChildrenLoaded();
            this._childCount = this._childNodes.size();
            index = this.getIndex(o);
            if (index != -1) {
                LazyTreeNode child = (LazyTreeNode)this._childNodes.get(index);
                this.notifyChildNodeAdded(this, index, child);
            }
        }
    }

    public void childRemoved(Object o) {
        if (this._childCount != -1) {
            --this._childCount;
        }
        if (this._isLoaded) {
            int index = this.getIndex(o);
            if (index < 0) {
                ++this._childCount;
            } else {
                LazyTreeNode child = (LazyTreeNode)this._childNodes.remove(index);
                child.dispose();
                this.notifyChildNodeRemoved(this, index, child);
            }
        }
    }

    public Enumeration children() {
        this.ensureChildrenLoaded();
        return Collections.enumeration(this._childNodes);
    }

    private void clearNodes() {
        if (this._childNodes != null) {
            this._childCount = 0;
            for (LazyTreeNode node : this._childNodes) {
                node.dispose();
            }
            this._childNodes.clear();
        }
    }

    private LazyTreeNode createErrorNode(Object o) {
        return new ErrorLazyTreeNode(this, o);
    }

    protected abstract LazyTreeNode createNode(Object var1);

    protected void dispose() {
        if (this._childNodes != null) {
            for (LazyTreeNode node : this._childNodes) {
                node.dispose();
            }
        }
    }

    private void ensureChildCountLoaded() {
        if (this._childCount == -1) {
            this._childCount = this.getChildObjectCount();
        }
    }

    private void ensureChildrenLoaded() {
        if (!this._isLoaded) {
            this.loadNodes();
            this._isLoaded = true;
        }
    }

    protected void setIsLoaded(boolean isLoaded) {
        this._isLoaded = isLoaded;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int i) {
        this.ensureChildrenLoaded();
        if (i >= this._childNodes.size()) {
            i = this._childNodes.size() - 1;
        }
        return i == -1 ? null : (TreeNode)this._childNodes.get(i);
    }

    public int getChildCount() {
        this.ensureChildCountLoaded();
        return this._childCount;
    }

    protected abstract int getChildObjectCount();

    protected abstract Collection getChildObjects();

    protected abstract Comparator getComparator();

    public int getIndex(Object o) {
        int nChildren = this._childNodes.size();
        int index = -1;
        for (int i = 0; i < nChildren; ++i) {
            LazyTreeNode node = (LazyTreeNode)this._childNodes.get(i);
            if (!LazyTreeNode.equals(node.getUserObject(), o)) continue;
            index = i;
        }
        return index;
    }

    public int getIndex(TreeNode node) {
        this.ensureChildrenLoaded();
        return this._childNodes.indexOf(node);
    }

    public LazyTreeNode getLazyTreeNodeParent() {
        return this._parent;
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public int getUserObjectIndex(Object o) {
        this.ensureChildrenLoaded();
        int index = -1;
        int nNodes = this._childNodes.size();
        for (int i = 0; i < nNodes; ++i) {
            LazyTreeNode node = (LazyTreeNode)this._childNodes.get(i);
            if (!LazyTreeNode.equals(node.getUserObject(), o)) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean isLeaf() {
        if (this.isDuplicate()) {
            return true;
        }
        this.ensureChildCountLoaded();
        return this._childCount == 0;
    }

    protected void loadChildObjects(Collection childObjects) {
        if (this._childNodes == null) {
            this._childNodes = new ArrayList();
        } else {
            this._childNodes.clear();
        }
        if (this._isSorted) {
            ArrayList sortedChildObject = new ArrayList(childObjects);
            Collections.sort(sortedChildObject, this.getComparator());
            childObjects = sortedChildObject;
        }
        for (Object child : childObjects) {
            LazyTreeNode childNode;
            try {
                childNode = this.createNode(child);
            }
            catch (Exception e) {
                if (Log.getLogger().isLoggable(Level.FINE)) {
                    Log.getLogger().log(Level.FINE, "Exception caught ", e);
                } else {
                    Log.getLogger().warning("Exception caught " + e.toString());
                    Log.getLogger().warning(" For more information use fine logging");
                }
                childNode = this.createErrorNode(child);
            }
            this._childNodes.add(childNode);
        }
        this._childCount = this._childNodes.size();
    }

    private void loadNodes() {
        Collection childObjects = this.getChildObjects();
        this.loadChildObjects(childObjects);
    }

    public void notifyChildNodeAdded(LazyTreeNode parent, int index, LazyTreeNode child) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + child);
        } else {
            this._parent.notifyChildNodeAdded(parent, index, child);
        }
    }

    public void notifyChildNodeRemoved(LazyTreeNode parent, int index, LazyTreeNode child) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + child);
        } else {
            this._parent.notifyChildNodeRemoved(parent, index, child);
        }
    }

    public void notifyNodeChanged(LazyTreeNode node) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + node);
        } else {
            this._parent.notifyNodeChanged(node);
        }
    }

    public void notifyNodeStructureChanged(LazyTreeNode node) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + node);
        } else {
            this._parent.notifyNodeStructureChanged(node);
        }
    }

    public void reload() {
        this.clearNodes();
        this.loadNodes();
        this.notifyNodeStructureChanged(this);
    }

    public void reload(Object userObject) {
        this._userObject = userObject;
        this.reload();
    }

    public String toString() {
        return "LazyTreeNode(" + this._userObject + ")";
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public boolean isSorted() {
        return this._isSorted;
    }
}

