/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public abstract class LazyTreeRoot
extends LazyTreeNode {
    private LazyTreeModel _model;

    protected LazyTreeRoot(Object o) {
        this(CollectionUtilities.createCollection(o), false);
    }

    protected LazyTreeRoot(Collection c) {
        this(c, false);
    }

    protected LazyTreeRoot(Object o, boolean isSorted) {
        super(null, CollectionUtilities.createCollection(o), isSorted);
    }

    protected LazyTreeRoot(Collection c, boolean isSorted) {
        super(null, LazyTreeRoot.getRootCollection(c, isSorted), isSorted);
    }

    private static Collection getRootCollection(Collection c, boolean isSorted) {
        if (isSorted) {
            ArrayList sortedList = new ArrayList(c);
            Collections.sort(sortedList, new FrameComparator());
            c = sortedList;
        }
        return c;
    }

    protected int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public Collection getChildObjects() {
        return (Collection)this.getUserObject();
    }

    public void childReplaced(Object oldUserObj, Object newUserObj) {
        List userObj = (List)this.getUserObject();
        int index = userObj.indexOf(oldUserObj);
        if (index < 0) {
            if (Log.getLogger().isLoggable(Level.FINE)) {
                Log.getLogger().fine("Could not replace object " + oldUserObj + " with " + newUserObj + " in tree root. Object not found.");
            }
            return;
        }
        userObj.set(index, newUserObj);
    }

    public void notifyChildNodeAdded(LazyTreeNode parent, int index, LazyTreeNode child) {
        this._model.nodesWereInserted(parent, new int[]{index});
    }

    public void notifyChildNodeRemoved(LazyTreeNode parent, int index, LazyTreeNode child) {
        this._model.nodesWereRemoved(parent, new int[]{index}, new Object[]{child});
    }

    public void notifyNodeChanged(LazyTreeNode node) {
        this._model.nodeChanged(node);
    }

    public void notifyNodeStructureChanged(LazyTreeNode node) {
        this._model.nodeStructureChanged(node);
    }

    public void setModel(LazyTreeModel model) {
        this._model = model;
    }
}

