/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyLoggerImpl
implements Log.LegacyLogger {
    private Level OLD_TRACE = Level.INFO;
    private Level OLD_WARNING = Level.WARNING;
    private Level OLD_ERROR = Level.WARNING;
    private Level OLD_EXCEPTION = Level.WARNING;
    private Level OLD_ENTER = Level.INFO;
    private Level OLD_EXIT = Level.INFO;
    private Logger logger;

    public LegacyLoggerImpl(Logger logger) {
        this.logger = logger;
    }

    private static String getClassName(Object o) {
        String name = o instanceof Class ? ((Class)o).getName() : o.getClass().getName();
        return name;
    }

    public void enter(Object object, String methodName, Object[] args) {
        this.logger.logp(this.OLD_ENTER, LegacyLoggerImpl.getClassName(object), methodName, "ENTER", args);
    }

    public void exit(Object object, String methodName, Object[] args) {
        this.logger.logp(this.OLD_EXIT, LegacyLoggerImpl.getClassName(object), methodName, "EXIT", args);
    }

    public void trace(String entry, Object object, String methodName, Object[] args) {
        this.logger.logp(this.OLD_TRACE, LegacyLoggerImpl.getClassName(object), methodName, entry, args);
    }

    public void warning(String entry, Object object, String methodName, Object[] args) {
        this.logger.logp(this.OLD_WARNING, LegacyLoggerImpl.getClassName(object), methodName, entry, args);
    }

    public void error(String entry, Object object, String methodName, Object[] args) {
        this.logger.logp(this.OLD_ERROR, LegacyLoggerImpl.getClassName(object), methodName, entry, args);
    }

    public void exception(Throwable e, Object object, String methodName, Object[] args) {
        this.logger.logp(this.OLD_EXCEPTION, LegacyLoggerImpl.getClassName(object), methodName, "Exception Caught", e);
    }

    public void stack(String entry, Object object, String methodName, Object[] args) {
        new RuntimeException(entry).printStackTrace();
    }
}

