/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JList;

public abstract class ListDragSourceListener
implements DragGestureListener,
DragSourceListener {
    private int[] _indexes;
    private Collection _objects;

    public abstract void doCopy(JComponent var1, int[] var2, Collection var3);

    public abstract void doMove(JComponent var1, int[] var2, Collection var3);

    public void dragDropEnd(DragSourceDropEvent e) {
        if (e.getDropSuccess()) {
            JComponent c = (JComponent)e.getDragSourceContext().getComponent();
            int action = e.getDropAction();
            if (action == 2) {
                this.doMove(c, this._indexes, this._objects);
            } else if (action == 1) {
                this.doCopy(c, this._indexes, this._objects);
            }
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        JList list = (JList)e.getComponent();
        if (ComponentUtilities.isDragAndDropEnabled(list)) {
            this._indexes = list.getSelectedIndices();
            this._objects = Arrays.asList(list.getSelectedValues());
            if (!this._objects.isEmpty()) {
                TransferableCollection t = new TransferableCollection(this._objects);
                e.startDrag(DragSource.DefaultMoveDrop, t, this);
            }
        }
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }
}

