/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Collection;
import javax.swing.JList;

public class ListTarget
implements DropTargetListener {
    private int _dropSelectionIndex = -1;
    private Object _dropTargetArea;

    private void clearDropSelection(JList list) {
        list.putClientProperty(DefaultRenderer.DROP_TARGET, null);
        list.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, null);
        this.setDropSelectionIndex(list, -1);
    }

    public void doDrop(JList list, Collection sources, int targetIndex, Object dropArea) {
        int dropIndex = targetIndex;
        if (dropArea == DefaultRenderer.DROP_TARGET_AREA_BELOW) {
            ++dropIndex;
        }
        SimpleListModel model = (SimpleListModel)list.getModel();
        int[] indices = list.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int sourceIndex = indices[i];
            model.moveValue(sourceIndex, dropIndex);
            if (sourceIndex <= dropIndex) continue;
            ++dropIndex;
        }
        list.setSelectionInterval(indices[0], indices[indices.length - 1]);
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
        this.clearDropSelection((JList)e.getDropTargetContext().getComponent());
    }

    public void dragOver(DropTargetDragEvent e) {
        e.acceptDrag(e.getDropAction());
        this.setDropSelection(e);
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        boolean succeeded = false;
        JList list = (JList)e.getDropTargetContext().getComponent();
        this.setDropSelection(list, e.getLocation());
        if (this._dropSelectionIndex != -1 && e.isDataFlavorSupported(TransferableCollection.getCollectionFlavor())) {
            try {
                int action = e.getDropAction();
                e.acceptDrop(action);
                Collection sources = (Collection)e.getTransferable().getTransferData(TransferableCollection.getCollectionFlavor());
                this.doDrop(list, sources, this._dropSelectionIndex, this._dropTargetArea);
            }
            catch (Exception ex) {
                Log.getLogger().severe(Log.toString(ex));
            }
        } else {
            e.rejectDrop();
            Log.getLogger().warning("unsupported flavor: " + e);
        }
        e.dropComplete(succeeded);
        this.clearDropSelection(list);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void setDropSelection(DropTargetDragEvent e) {
        this.setDropSelection((JList)e.getDropTargetContext().getComponent(), e.getLocation());
    }

    private void setDropSelection(JList list, Point p) {
        int index = list.locationToIndex(p);
        if (index == -1) {
            this.clearDropSelection(list);
        } else {
            Object object = list.getModel().getElementAt(index);
            Rectangle r = list.getCellBounds(index, index);
            if (p.y < r.y + r.height / 2) {
                this._dropTargetArea = DefaultRenderer.DROP_TARGET_AREA_ABOVE;
            } else if (index == list.getModel().getSize() - 1) {
                this._dropTargetArea = DefaultRenderer.DROP_TARGET_AREA_BELOW;
            } else {
                this._dropTargetArea = DefaultRenderer.DROP_TARGET_AREA_ABOVE;
                object = list.getModel().getElementAt(++index);
            }
            list.putClientProperty(DefaultRenderer.DROP_TARGET, object);
            list.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, this._dropTargetArea);
            this.setDropSelectionIndex(list, index);
        }
    }

    private void setDropSelectionIndex(JList list, int index) {
        this._dropSelectionIndex = index;
        list.repaint();
    }
}

