/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.EventDispatcher;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;

public abstract class ListenerCollection {
    private boolean _isPostingEnabled = true;
    private EventDispatcher _dispatcher;

    protected ListenerCollection(EventDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    public void add(Object source, EventListener listener) {
        Collection c = this.getListeners(source);
        if (c == null) {
            c = ListenerCollection.newCollection();
            this.saveListeners(source, c);
        } else if (this.isPosting(source)) {
            c = ListenerCollection.newCollection(c);
            this.saveListeners(source, c);
        }
        if (c.contains(listener)) {
            Log.getLogger().warning("duplicate listener: " + listener);
        }
        c.add(listener);
    }

    public abstract Collection getListeners(Object var1);

    public abstract Collection getSources();

    public abstract boolean hasListeners(Object var1);

    protected abstract boolean isPosting(Object var1);

    public boolean isPostingEnabled() {
        return this._isPostingEnabled;
    }

    private static Collection newCollection() {
        return new LinkedList();
    }

    private static Collection newCollection(Collection c) {
        return new LinkedList(c);
    }

    public void postEvent(Object source, int type) {
        this.postEvent(source, type, null, null, null);
    }

    public void postEvent(Object source, int type, Object arg1) {
        this.postEvent(source, type, arg1, null, null);
    }

    public void postEvent(Object source, int type, Object arg1, Object arg2) {
        this.postEvent(source, type, arg1, arg2, null);
    }

    public void postEvent(Object source, int type, Object arg1, Object arg2, Object arg3) {
        Collection c;
        if (this._isPostingEnabled && (c = this.getListeners(source)) != null && !c.isEmpty()) {
            boolean wasPosting = this.setStartPosting(source);
            this._dispatcher.postEvent(c, source, type, arg1, arg2, arg3);
            if (!wasPosting) {
                this.setFinishPosting(source);
            }
        }
    }

    public void remove(Object source, EventListener listener) {
        boolean wasAttached;
        Collection c = this.getListeners(source);
        if (c == null) {
            wasAttached = false;
        } else if (this.isPosting(source)) {
            c = ListenerCollection.newCollection(c);
            wasAttached = c.remove(listener);
            this.saveListeners(source, c);
        } else {
            wasAttached = c.remove(listener);
        }
        if (!wasAttached) {
            Log.getLogger().warning("listener not attached: " + listener);
        }
    }

    public abstract void removeAllListeners(Object var1);

    protected abstract void saveListeners(Object var1, Collection var2);

    protected abstract void setFinishPosting(Object var1);

    public boolean setPostingEnabled(boolean postingEnabled) {
        boolean wasEnabled = this._isPostingEnabled;
        this._isPostingEnabled = postingEnabled;
        return wasEnabled;
    }

    protected abstract boolean setStartPosting(Object var1);

    public String toString() {
        return this.getClass().getName();
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }
}

