/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Map;

public class LocalizeUtils {
    public static void localize(Object o, KnowledgeBase kb) {
        if (o != null) {
            if (o instanceof Collection) {
                LocalizeUtils.localizeCollection((Collection)o, kb);
            } else if (o instanceof Map) {
                LocalizeUtils.localizeMap((Map)o, kb);
            } else if (o instanceof Localizable) {
                ((Localizable)o).localize(kb);
            } else if (!(o instanceof Remote && o instanceof Proxy || LocalizeUtils.isPrimative(o))) {
                Log.getLogger().warning("Unhandled localization: " + o);
            }
        }
    }

    private static boolean isPrimative(Object o) {
        return o instanceof String || o instanceof Boolean || o instanceof Integer || o instanceof Float;
    }

    private static void localizeCollection(Collection values, KnowledgeBase kb) {
        for (Object o : values) {
            LocalizeUtils.localize(o, kb);
        }
    }

    private static void localizeMap(Map values, KnowledgeBase kb) {
        for (Map.Entry entry : values.entrySet()) {
            LocalizeUtils.localize(entry.getKey(), kb);
            LocalizeUtils.localize(entry.getValue(), kb);
        }
    }
}

