/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ConsoleFormatter;
import edu.stanford.smi.protege.util.FileFormatter;
import edu.stanford.smi.protege.util.LegacyLoggerImpl;
import edu.stanford.smi.protege.util.MessageError;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private static boolean debug = false;
    private static boolean displayedIOWarning = false;
    private static Logger logger;
    private static LegacyLogger legacyLogger;
    private static Handler consoleHandler;
    private static Handler fileHandler;
    private static boolean configuredByFile;

    private Log() {
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("protege.system");
            if (!configuredByFile) {
                try {
                    logger.setUseParentHandlers(false);
                    logger.setLevel(Level.ALL);
                    Log.addConsoleHandler();
                    Log.addFileHandler();
                }
                catch (Throwable e) {
                    System.out.println("Exception configuring logger");
                }
            }
        }
        return logger;
    }

    public static void emptyCatchBlock(Throwable t) {
        if (Log.getLogger().isLoggable(Level.FINE)) {
            Log.getLogger().log(Level.FINE, "Exception Caught", t);
        }
    }

    public static Logger getLogger(Class c) {
        Logger l;
        block4: {
            l = Logger.getLogger(c.getName());
            if (!configuredByFile) {
                try {
                    l.addHandler(Log.getFileHandler());
                    Handler consoleHandler = Log.getConsoleHandler();
                    if (l != null && consoleHandler != null) {
                        l.addHandler(consoleHandler);
                    }
                }
                catch (Throwable e) {
                    if (displayedIOWarning) break block4;
                    System.err.println("Warning: IO exception getting logger. " + e.getMessage());
                    displayedIOWarning = true;
                }
            }
        }
        return l;
    }

    public static void makeInheritedLoggersLocal(Logger logger) {
        Handler[] inheritedHandlers;
        logger.setUseParentHandlers(false);
        if (logger.getHandlers() != null && logger.getHandlers().length > 0) {
            return;
        }
        for (Handler inheritedHandler : inheritedHandlers = Log.getInheritedHandlers(logger)) {
            logger.addHandler(inheritedHandler);
        }
    }

    private static Handler[] getInheritedHandlers(Logger logger) {
        Handler[] inheritedHandlers = logger.getHandlers();
        while (inheritedHandlers.length == 0) {
            Logger parentLogger = logger.getParent();
            if (parentLogger == null) {
                return inheritedHandlers;
            }
            logger = parentLogger;
            inheritedHandlers = parentLogger.getHandlers();
        }
        return inheritedHandlers;
    }

    public static void setLoggingLevel(Class<?> c, Level level) {
        Logger.getLogger(c.getName()).setLevel(level);
    }

    public static void handleErrors(Logger log, Level level, Collection errors) {
        if (errors == null || errors.size() == 0) {
            return;
        }
        log.log(level, "Errors found performing operation.\n\n");
        for (Object o : errors) {
            if (o instanceof MessageError) {
                MessageError me = (MessageError)o;
                log.log(level, me.getMessage(), me.getException());
                continue;
            }
            if (o instanceof Throwable) {
                Throwable t = (Throwable)o;
                log.log(level, "Exception caught", t);
                continue;
            }
            log.log(level, o == null ? "(missing error message)" : o.toString());
        }
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        t.printStackTrace(printer);
        printer.flush();
        return ((Object)writer).toString();
    }

    private static void addConsoleHandler() {
        Handler consoleHandler = Log.getConsoleHandler();
        if (logger != null && consoleHandler != null) {
            logger.addHandler(consoleHandler);
        }
    }

    private static Handler getConsoleHandler() {
        try {
            if (consoleHandler == null) {
                consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new ConsoleFormatter());
                consoleHandler.setLevel(Level.ALL);
            }
            return consoleHandler;
        }
        catch (Throwable e) {
            System.err.println("Warning: Cannot set console log debugger handler.");
            return null;
        }
    }

    private static void addFileHandler() {
        try {
            Handler handler = Log.getFileHandler();
            logger.addHandler(handler);
            handler.publish(new LogRecord(Level.INFO, "*** SYSTEM START ***"));
        }
        catch (Throwable e) {
            System.err.println("Error adding file handler to logger");
        }
    }

    private static Handler getFileHandler() throws IOException {
        if (fileHandler == null) {
            File file = ApplicationProperties.getLogFileDirectory();
            String path = file == null ? "%t" : file.getPath();
            fileHandler = new FileHandler(path + File.separatorChar + "protege_%u.log", true);
            fileHandler.setFormatter(new FileFormatter());
            fileHandler.setLevel(Level.ALL);
        }
        return fileHandler;
    }

    private static File getApplicationDirectory() {
        String dir = Log.getSystemProperty("protege.dir");
        if (dir == null) {
            dir = Log.getSystemProperty("user.dir");
        }
        return dir == null ? null : new File(dir);
    }

    private static String getSystemProperty(String property) {
        String value;
        try {
            value = System.getProperty(property);
        }
        catch (SecurityException e) {
            value = null;
        }
        return value;
    }

    private static LegacyLogger getLegacyLogger() {
        if (legacyLogger == null) {
            legacyLogger = new LegacyLoggerImpl(Log.getLogger());
        }
        return legacyLogger;
    }

    @Deprecated
    public static void enter(Object thisOrClass, String methodName) {
        Log.getLegacyLogger().enter(thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void enter(Object thisOrClass, String methodName, Object arg1) {
        Log.getLegacyLogger().enter(thisOrClass, methodName, new Object[]{arg1});
    }

    @Deprecated
    public static void enter(Object thisOrClass, String methodName, Object arg1, Object arg2) {
        Log.getLegacyLogger().enter(thisOrClass, methodName, new Object[]{arg1, arg2});
    }

    @Deprecated
    public static void enter(Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3) {
        Log.getLegacyLogger().enter(thisOrClass, methodName, new Object[]{arg1, arg2, arg3});
    }

    @Deprecated
    public static void enter(Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.getLegacyLogger().enter(thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4});
    }

    @Deprecated
    public static void enter(Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Log.getLegacyLogger().enter(thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    @Deprecated
    public static void error(String description, Object thisOrClass, String methodName) {
        Log.getLegacyLogger().error(description, thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void error(String description, Object thisOrClass, String methodName, Object arg1) {
        Log.getLegacyLogger().error(description, thisOrClass, methodName, new Object[]{arg1});
    }

    @Deprecated
    public static void error(String description, Object thisOrClass, String methodName, Object arg1, Object arg2) {
        Log.getLegacyLogger().error(description, thisOrClass, methodName, new Object[]{arg1, arg2});
    }

    @Deprecated
    public static void error(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3) {
        Log.getLegacyLogger().error(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3});
    }

    @Deprecated
    public static void error(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.getLegacyLogger().error(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4});
    }

    @Deprecated
    public static void error(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Log.getLegacyLogger().error(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    @Deprecated
    public static void exception(Throwable exception, Object thisOrClass, String methodName) {
        Log.getLegacyLogger().exception(exception, thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void exception(Throwable exception, Object thisOrClass, String methodName, Object arg1) {
        Log.getLegacyLogger().exception(exception, thisOrClass, methodName, new Object[]{arg1});
    }

    @Deprecated
    public static void exception(Throwable exception, Object thisOrClass, String methodName, Object arg1, Object arg2) {
        Log.getLegacyLogger().exception(exception, thisOrClass, methodName, new Object[]{arg1, arg2});
    }

    @Deprecated
    public static void exception(Throwable exception, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3) {
        Log.getLegacyLogger().exception(exception, thisOrClass, methodName, new Object[]{arg1, arg2, arg3});
    }

    @Deprecated
    public static void exception(Throwable exception, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.getLegacyLogger().exception(exception, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4});
    }

    @Deprecated
    public static void exception(Throwable exception, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Log.getLegacyLogger().exception(exception, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    @Deprecated
    public static void exit(Object thisOrClass, String methodName) {
        Log.getLegacyLogger().exit(thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void stack(String description, Object thisOrClass, String methodName) {
        Log.getLegacyLogger().stack(description, thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void stack(String description, Object thisOrClass, String methodName, Object arg1) {
        Log.getLegacyLogger().stack(description, thisOrClass, methodName, new Object[]{arg1});
    }

    @Deprecated
    public static void stack(String description, Object thisOrClass, String methodName, Object arg1, Object arg2) {
        Log.getLegacyLogger().stack(description, thisOrClass, methodName, new Object[]{arg1, arg2});
    }

    @Deprecated
    public static void stack(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3) {
        Log.getLegacyLogger().stack(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3});
    }

    @Deprecated
    public static void stack(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.getLegacyLogger().stack(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4});
    }

    @Deprecated
    public static void trace(String description, Object thisOrClass, String methodName) {
        Log.getLegacyLogger().trace(description, thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void trace(String description, Object thisOrClass, String methodName, Object arg1) {
        Log.getLegacyLogger().trace(description, thisOrClass, methodName, new Object[]{arg1});
    }

    @Deprecated
    public static void trace(String description, Object thisOrClass, String methodName, Object arg1, Object arg2) {
        Log.getLegacyLogger().trace(description, thisOrClass, methodName, new Object[]{arg1, arg2});
    }

    @Deprecated
    public static void trace(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3) {
        Log.getLegacyLogger().trace(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3});
    }

    @Deprecated
    public static void trace(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.getLegacyLogger().trace(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4});
    }

    @Deprecated
    public static void trace(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Log.getLegacyLogger().trace(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    @Deprecated
    public static void warning(String description, Object thisOrClass, String methodName) {
        Log.getLegacyLogger().warning(description, thisOrClass, methodName, new Object[0]);
    }

    @Deprecated
    public static void warning(String description, Object thisOrClass, String methodName, Object arg1) {
        Log.getLegacyLogger().warning(description, thisOrClass, methodName, new Object[]{arg1});
    }

    @Deprecated
    public static void warning(String description, Object thisOrClass, String methodName, Object arg1, Object arg2) {
        Log.getLegacyLogger().warning(description, thisOrClass, methodName, new Object[]{arg1, arg2});
    }

    @Deprecated
    public static void warning(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3) {
        Log.getLegacyLogger().warning(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3});
    }

    @Deprecated
    public static void warning(String description, Object thisOrClass, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.getLegacyLogger().warning(description, thisOrClass, methodName, new Object[]{arg1, arg2, arg3, arg4});
    }

    static {
        String debugLogProperty = "log.config.debug";
        try {
            if (System.getProperty(debugLogProperty) != null) {
                debug = true;
            }
        }
        catch (Throwable t) {
            debug = false;
        }
        configuredByFile = false;
        boolean configured = false;
        String logProperty = "java.util.logging.config.file";
        try {
            String rootDir;
            File applicationDirectory = Log.getApplicationDirectory();
            String string = rootDir = applicationDirectory == null ? null : applicationDirectory.getAbsolutePath();
            if (System.getProperty(logProperty) != null) {
                if (debug) {
                    System.out.println("Logger already configured...");
                }
                configuredByFile = true;
                configured = true;
            } else if (rootDir != null) {
                File logconfig = new File(rootDir + File.separator + "logging.properties");
                if (debug) {
                    System.out.println("Logging file = " + logconfig);
                }
                if (logconfig.canRead()) {
                    if (debug) {
                        System.out.println("Logging file readable");
                    }
                    System.setProperty(logProperty, logconfig.getAbsolutePath());
                    LogManager.getLogManager().readConfiguration();
                    configuredByFile = true;
                    configured = true;
                    if (debug) {
                        System.out.println("Configuration done by util.Log class ");
                    }
                }
            }
        }
        catch (Throwable e) {
            System.out.println("Could not set up class specific logging");
        }
        if (!configured) {
            if (debug) {
                System.out.println("using default configuration.");
            }
            try {
                Log.getLogger().setLevel(Level.CONFIG);
            }
            catch (Throwable t) {
                System.out.println("Could not set logger level");
            }
        }
    }

    static interface LegacyLogger {
        public void enter(Object var1, String var2, Object[] var3);

        public void exit(Object var1, String var2, Object[] var3);

        public void trace(String var1, Object var2, String var3, Object[] var4);

        public void warning(String var1, Object var2, String var3, Object[] var4);

        public void error(String var1, Object var2, String var3, Object[] var4);

        public void exception(Throwable var1, Object var2, String var3, Object[] var4);

        public void stack(String var1, Object var2, String var3, Object[] var4);
    }
}

