/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

public class MessageError {
    private Throwable exception;
    private String message;
    private Severity severity;

    public MessageError(String message) {
        this(null, message);
    }

    public MessageError(Throwable ex) {
        this(ex, null);
    }

    public MessageError(Throwable ex, String message) {
        this(ex, message, Severity.WARNING);
    }

    public MessageError(Throwable ex, String message, Severity severity) {
        this.exception = ex;
        this.message = message;
        this.severity = severity;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return this.severity.toString() + ": " + (this.message != null ? this.message : this.exception.getMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR,
        FATAL;

    }
}

