/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.MessagePanel;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ModalDialog
extends JDialog
implements Disposable {
    private static final long serialVersionUID = 7759975948915176435L;
    public static final int OPTION_OK = 1;
    public static final int OPTION_YES = 2;
    public static final int OPTION_NO = 3;
    public static final int OPTION_CANCEL = 4;
    public static final int OPTION_CLOSE = 5;
    public static final int RESULT_ERROR = 6;
    public static final int MODE_OK_CANCEL = 11;
    public static final int MODE_YES_NO_CANCEL = 12;
    public static final int MODE_YES_NO = 13;
    public static final int MODE_CLOSE = 14;
    private int _result;
    private Component _panel;
    private JPanel _buttonsPanel;
    private CloseCallback _closeCallback;
    private boolean _enableCloseButton;
    private static ModalDialog _currentDialog;

    private ModalDialog(Dialog parent, Component panel, String title, int mode, CloseCallback callback, boolean enableClose) {
        super(parent, title, true);
        this.init(panel, mode, callback, enableClose);
    }

    private ModalDialog(Frame parentFrame, Component panel, String title, int mode, CloseCallback callback, boolean enableCloseButton) {
        super(parentFrame, title, true);
        this.init(panel, mode, callback, enableCloseButton);
    }

    public static void attemptDialogClose(int result) {
        ModalDialog dialog = ModalDialog.getCurrentDialog();
        if (dialog != null) {
            dialog.attemptClose(result);
        }
    }

    public void attemptClose(int result) {
        Validatable validatable;
        boolean canClose = this._closeCallback == null ? true : this._closeCallback.canClose(result);
        if (canClose && result == 1 && this._panel instanceof Validatable && (canClose = (validatable = (Validatable)((Object)this._panel)).validateContents())) {
            validatable.saveContents();
        }
        if (canClose) {
            this._result = result;
            this.close();
        }
    }

    private void close() {
        ComponentUtilities.dispose(this);
        _currentDialog = null;
    }

    private JButton createButton(final int result, ResourceKey key) {
        StandardAction action = new StandardAction(key){
            private static final long serialVersionUID = 1079564194674970833L;

            public void actionPerformed(ActionEvent event) {
                ModalDialog.this.attemptClose(result);
            }
        };
        JButton button = ComponentFactory.createButton(action);
        button.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        ModalDialog.this.attemptClose(result);
                        break;
                    }
                    case 27: {
                        ModalDialog.this.attemptClose(4);
                        break;
                    }
                }
            }
        });
        return button;
    }

    private JPanel createButtonsPanel(int mode) {
        JPanel buttonsGrid = ComponentFactory.createPanel();
        buttonsGrid.setLayout(new GridLayout(1, 3, 10, 10));
        switch (mode) {
            case 11: {
                buttonsGrid.add(this.createButton(1, ResourceKey.OK_BUTTON_LABEL));
                buttonsGrid.add(this.createButton(4, ResourceKey.CANCEL_BUTTON_LABEL));
                break;
            }
            case 13: {
                buttonsGrid.add(this.createButton(2, ResourceKey.YES_BUTTON_LABEL));
                buttonsGrid.add(this.createButton(3, ResourceKey.NO_BUTTON_LABEL));
                break;
            }
            case 12: {
                buttonsGrid.add(this.createButton(2, ResourceKey.YES_BUTTON_LABEL));
                buttonsGrid.add(this.createButton(3, ResourceKey.NO_BUTTON_LABEL));
                buttonsGrid.add(this.createButton(4, ResourceKey.CANCEL_BUTTON_LABEL));
                break;
            }
            case 14: {
                buttonsGrid.add(this.createButton(5, ResourceKey.CLOSE_BUTTON_LABEL));
                break;
            }
        }
        JPanel panel = ComponentFactory.createPanel();
        panel.setLayout(new FlowLayout());
        panel.add(buttonsGrid);
        return panel;
    }

    public static ModalDialog getCurrentDialog() {
        return _currentDialog;
    }

    private void getFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JButton button = (JButton)((Container)ModalDialog.this._buttonsPanel.getComponent(0)).getComponent(0);
                button.requestFocus();
            }
        });
    }

    private void init(Component panel, int mode, CloseCallback callback, boolean enableCloseButton) {
        _currentDialog = this;
        this._closeCallback = callback;
        this._enableCloseButton = enableCloseButton;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloseListener());
        switch (mode) {
            case 11: {
                this._result = 4;
                break;
            }
            case 12: {
                this._result = 4;
                break;
            }
            case 14: {
                this._result = 5;
                break;
            }
        }
        this._panel = panel;
        this._buttonsPanel = this.createButtonsPanel(mode);
        this.layoutWidgets();
        this.pack();
        ComponentUtilities.center(this);
        this.getFocus();
        this.setVisible(true);
    }

    private void layoutWidgets() {
        JPanel borderedPanel = ComponentFactory.createPanel();
        borderedPanel.setLayout(new BorderLayout());
        borderedPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        borderedPanel.add(this._panel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)borderedPanel, "Center");
        this.getContentPane().add((Component)this._buttonsPanel, "South");
    }

    public static int showDialog(Component parent, Component panel, String title, int mode) {
        return ModalDialog.showDialog(parent, panel, title, mode, null);
    }

    public static int showDialog(Component parent, Component panel, String title, int mode, CloseCallback callback) {
        return ModalDialog.showDialog(parent, panel, title, mode, callback, true);
    }

    public static int showDialog(Component parent, Component panel, String title, int mode, CloseCallback callback, boolean enableCloseButton) {
        Window window = parent == null || parent instanceof Window ? (Window)parent : SwingUtilities.windowForComponent(parent);
        ModalDialog dialog = window instanceof Frame || window == null ? new ModalDialog((Frame)window, panel, title, mode, callback, enableCloseButton) : new ModalDialog((Dialog)window, panel, title, mode, callback, enableCloseButton);
        int result = dialog == null ? 6 : dialog._result;
        return result;
    }

    public static void showMessageDialog(Component parent, String message) {
        ModalDialog.showMessageDialog(parent, message, 14);
    }

    public static void showMessageDialog(Component parent, String message, String title) {
        ModalDialog.showMessageDialog(parent, message, title, 14);
    }

    public static int showMessageDialog(Component parent, String message, int mode) {
        return ModalDialog.showDialog(parent, new MessagePanel(message), "", mode);
    }

    public static int showMessageDialog(Component parent, String message, String title, int mode) {
        return ModalDialog.showDialog(parent, new MessagePanel(message), title, mode);
    }

    public static Action getCloseAction(final Component c) {
        return new AbstractAction(){
            private static final long serialVersionUID = -3726864269823423931L;

            public void actionPerformed(ActionEvent event) {
                Component root = SwingUtilities.getRoot(c);
                if (root instanceof ModalDialog) {
                    ModalDialog dialog = (ModalDialog)root;
                    dialog.attemptClose(1);
                }
            }
        };
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        public void windowClosing(WindowEvent event) {
            int result;
            int option = 4;
            if (!ModalDialog.this._enableCloseButton && (result = ModalDialog.showMessageDialog((Component)ModalDialog.this, LocalizedText.getText(ResourceKey.DIALOG_SAVE_CHANGES_TEXT), 13)) == 2) {
                option = 1;
            }
            ModalDialog.this.attemptClose(option);
        }
    }

    public static interface CloseCallback {
        public boolean canClose(int var1);
    }
}

