/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMap<X, Y> {
    private Map<X, Collection<Y>> _map;

    protected MultiMap() {
        this(11);
    }

    protected MultiMap(int initSize) {
        this._map = new HashMap<X, Collection<Y>>(initSize);
    }

    public void addValue(X key, Y value) {
        Collection<Y> c = this._map.get(key);
        if (c == null) {
            c = this.createCollection();
            this._map.put(key, c);
        }
        c.add(value);
    }

    public void addValues(X key, Collection<Y> values) {
        Collection<Y> c = this._map.get(key);
        if (c == null) {
            c = this.createCollection();
            this._map.put(key, c);
        }
        c.addAll(values);
    }

    public abstract Collection<Y> createCollection();

    public Collection<X> getKeys() {
        return this._map.keySet();
    }

    public Collection<Y> getValues(X key) {
        return this._map.get(key);
    }

    public Collection<Y> removeKey(X key) {
        return this._map.remove(key);
    }

    public void removeValue(X key, Y value) {
        boolean succeeded;
        Collection<Y> c = this._map.get(key);
        if (c != null && !(succeeded = c.remove(value))) {
            Log.getLogger().warning("value not found: " + value);
        }
    }

    public void removeValues(X key, Collection<Y> values) {
        Collection<Y> c = this._map.get(key);
        c.removeAll(values);
    }

    public void clear() {
        this._map.clear();
    }
}

