/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class MultiplexingClassLoader
extends ClassLoader {
    private Collection childLoaders;

    public MultiplexingClassLoader(Collection childLoaders) {
        this.childLoaders = new ArrayList(childLoaders);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> clas = null;
        Iterator i = this.childLoaders.iterator();
        while (i.hasNext() && clas == null) {
            ClassLoader child = (ClassLoader)i.next();
            try {
                clas = child.loadClass(name);
            }
            catch (ClassNotFoundException e) {}
        }
        if (clas == null) {
            clas = super.findClass(name);
        }
        return clas;
    }

    protected URL findResource(String name) {
        URL resource = null;
        Iterator i = this.childLoaders.iterator();
        while (i.hasNext() && resource == null) {
            ClassLoader child = (ClassLoader)i.next();
            resource = child.getResource(name);
        }
        if (resource == null) {
            resource = super.findResource(name);
        }
        return resource;
    }

    protected Enumeration findResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        for (ClassLoader child : this.childLoaders) {
            ArrayList<URL> childResources = Collections.list(child.getResources(name));
            resources.addAll(childResources);
        }
        ArrayList<URL> superResources = Collections.list(super.findResources(name));
        resources.addAll(superResources);
        return Collections.enumeration(resources);
    }
}

