/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.URLPanel;
import edu.stanford.smi.protege.util.Validatable;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ProjectChooser
extends JFileChooser {
    private static final long serialVersionUID = 33858734669640699L;
    private static Logger log = Log.getLogger(ProjectChooser.class);
    private JPanel pane;
    private CardLayout layout = new CardLayout();
    public static final String FILE_CARD = "File";
    public static final String URL_CARD = "URL";
    public static final String SERVER_CARD = "Server";
    private ButtonGroup buttonGroup = new ButtonGroup();
    private static final String CARD_NAME_PROPERTY = "project_chooser.selected_card";
    private JDialog dialog;
    private URLPanel urlPanel;
    private ServerPanel serverPanel;
    private int returnValue = 1;

    public ProjectChooser() {
        this.setControlButtonsAreShown(false);
        this.setDialogTitle("Open Project");
        String text = Text.getProgramName() + " Project";
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(".pprj");
        Collection classNames = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames();
        Iterator iterator = classNames.iterator();
        if (iterator.hasNext()) {
            text = "Supported Files";
        }
        while (iterator.hasNext()) {
            Class pluginClass = (Class)iterator.next();
            try {
                CreateProjectFromFilePlugin plugin = (CreateProjectFromFilePlugin)pluginClass.newInstance();
                String[] es = plugin.getSuffixes();
                for (int i = 0; i < es.length; ++i) {
                    String e = es[i];
                    extensions.add(e);
                }
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.INFO, "Exception caught", ex);
            }
        }
        this.setFileFilter(new ExtensionFilter(extensions.iterator(), text));
        this.setCurrentDirectory(ApplicationProperties.getLastFileDirectory());
        this.setName(FILE_CARD);
    }

    protected JDialog createDialog(Component parent) {
        this.dialog = super.createDialog(parent);
        Container contentPane = this.dialog.getContentPane();
        contentPane.remove(this);
        contentPane.setLayout(new BorderLayout());
        this.pane = new JPanel(this.layout);
        this.pane.add(FILE_CARD, this);
        this.urlPanel = new URLPanel();
        this.pane.add(URL_CARD, this.urlPanel);
        this.serverPanel = new ServerPanel();
        this.pane.add(SERVER_CARD, this.serverPanel);
        this.urlPanel.setBorder(this.getBorder());
        this.serverPanel.setBorder(this.getBorder());
        this.serverPanel.setName(SERVER_CARD);
        this.layout.show(this.pane, ApplicationProperties.getString(CARD_NAME_PROPERTY, FILE_CARD));
        contentPane.add((Component)this.createSelectionButtonPane(), "West");
        contentPane.add((Component)this.pane, "Center");
        contentPane.add((Component)this.createOKCancelButtonPane(), "South");
        return this.dialog;
    }

    private Component getActiveCard() {
        Component activeCard = null;
        for (int i = 0; i < this.pane.getComponentCount(); ++i) {
            Component c = this.pane.getComponent(i);
            if (!c.isVisible()) continue;
            activeCard = c;
            break;
        }
        return activeCard;
    }

    private void attemptClose(int result) {
        if (this.canClose(result)) {
            this.returnValue = result;
            this.dialog.setVisible(false);
        }
    }

    public boolean canClose(int result) {
        Component c;
        boolean canClose = true;
        if (result == 0 && (c = this.getActiveCard()) instanceof Validatable) {
            Validatable v = (Validatable)((Object)c);
            canClose = v.validateContents();
        }
        return canClose;
    }

    public int showOpenDialog(Component parent) {
        int dialogReturnValue = super.showOpenDialog(parent);
        if (dialogReturnValue == 0) {
            this.returnValue = 0;
        }
        Component c = this.getActiveCard();
        ApplicationProperties.setString(CARD_NAME_PROPERTY, c.getName());
        return this.returnValue;
    }

    private JPanel createSelectionButtonPane() {
        JPanel panel = new JPanel(new GridLayout(3, 1));
        panel.add(this.createSelectionButton(FILE_CARD));
        panel.add(this.createSelectionButton(URL_CARD));
        panel.add(this.createSelectionButton(SERVER_CARD));
        JPanel externalPanel = new JPanel(new FlowLayout(0));
        externalPanel.add(panel);
        return externalPanel;
    }

    private AbstractButton createSelectionButton(final String name) {
        AbstractAction action = new AbstractAction(name){
            private static final long serialVersionUID = 2317162047521094349L;

            public void actionPerformed(ActionEvent event) {
                ProjectChooser.this.layout.show(ProjectChooser.this.pane, name);
            }
        };
        JToggleButton button = new JToggleButton(action);
        int size = 75;
        button.setPreferredSize(new Dimension(size, size));
        this.buttonGroup.add(button);
        if (this.getActiveCard().getName().equals(name)) {
            button.setSelected(true);
        }
        return button;
    }

    private JComponent createOKCancelButtonPane() {
        JPanel panel = new JPanel(new GridLayout(1, 0, 10, 10));
        panel.add(this.createButton(0, ResourceKey.OK_BUTTON_LABEL));
        panel.add(this.createButton(1, ResourceKey.CANCEL_BUTTON_LABEL));
        JPanel externalPanel = new JPanel(new FlowLayout(1));
        externalPanel.add(panel);
        return externalPanel;
    }

    private JButton createButton(final int result, ResourceKey key) {
        StandardAction action = new StandardAction(key){
            private static final long serialVersionUID = -3338082593317941941L;

            public void actionPerformed(ActionEvent event) {
                ProjectChooser.this.attemptClose(result);
            }
        };
        JButton button = ComponentFactory.createButton(action);
        button.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        ProjectChooser.this.attemptClose(result);
                        break;
                    }
                    case 27: {
                        ProjectChooser.this.attemptClose(1);
                        break;
                    }
                }
            }
        });
        return button;
    }

    public Project getProject() {
        Project project = null;
        Component c = this.getActiveCard();
        if (c == this) {
            project = this.getProjectFromFile();
            ApplicationProperties.setLastFileDirectory(this.getCurrentDirectory());
        } else if (c == this.urlPanel) {
            URI uri = this.urlPanel.getURI();
            if (uri != null) {
                ApplicationProperties.setLastLoadedURI(uri);
                project = this.loadProject(uri);
            }
        } else if (c == this.serverPanel) {
            RemoteServer server = this.serverPanel.getServer();
            RemoteSession session = this.serverPanel.getSession();
            if (server != null || session != null) {
                if (this.serverPanel.isAdminsterServerActivated()) {
                    RemoteProjectManager.getInstance().showServerAdminWindow(server, session);
                } else {
                    project = this.getRemoteProject(server, session);
                }
            }
        } else {
            Log.getLogger().warning("bad component: " + c);
        }
        return project;
    }

    private Project getProjectFromFile() {
        Project project = null;
        ArrayList errors = new ArrayList();
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        String fileName = selectedFile.toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            String suffix = fileName.substring(lastDotIndex + 1);
            Collection availablePlugins = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames();
            Iterator it = availablePlugins.iterator();
            while (it.hasNext() && project == null) {
                Class pluginClass = (Class)it.next();
                project = this.useCreateProjectFromFilePlugin(pluginClass, suffix, fileName, errors);
                if (project == null) continue;
                String projectFilePath = fileName.substring(0, lastDotIndex) + ".pprj";
                project.setProjectFilePath(projectFilePath);
                break;
            }
            if (errors.size() > 0) {
                ProjectManager.getProjectManager().displayErrors("File load warnings and errors", errors);
            }
            if (project != null) {
                return project;
            }
        }
        URI uri = this.getSelectedFile().toURI();
        project = this.loadProject(uri);
        return project;
    }

    private Project getRemoteProject(RemoteServer server, RemoteSession session) {
        return RemoteProjectManager.getInstance().getServerProject(this, server, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project loadProject(URI uri) {
        Project project = null;
        ArrayList<MessageError> errors = new ArrayList<MessageError>();
        long t1 = System.currentTimeMillis();
        WaitCursor waitCursor = new WaitCursor(this);
        try {
            project = Project.loadProjectFromURI(uri, errors);
        }
        catch (Exception e) {
            errors.add(new MessageError(e));
            Log.getLogger().log(Level.SEVERE, "Error loading project", e);
        }
        finally {
            waitCursor.hide();
        }
        long t2 = System.currentTimeMillis();
        Log.getLogger().info("Project load time for " + uri + ": " + (t2 - t1) / 1000L + " sec");
        if (project != null && project.getProjectInstance() == null) {
            String errorMsg = "Unable to load file: " + uri + "\nPossible reasons:\n- The file has an unsupported file format\n- The file is not well-formed\n- The project file is corrupt";
            Log.getLogger().severe(errorMsg);
            errors.add(new MessageError(null, errorMsg));
        }
        ProjectManager.getProjectManager().displayErrors("Load Project Errors", errors);
        return project;
    }

    @Deprecated
    public Project useCreateProjectFromFilePlugin(Class pluginClass, String suffix, String fileName) {
        return this.useCreateProjectFromFilePlugin(pluginClass, suffix, fileName, new ArrayList());
    }

    public Project useCreateProjectFromFilePlugin(Class pluginClass, String suffix, String fileName, Collection errors) {
        CreateProjectFromFilePlugin plugin = this.getCreateProjectFromFilePluginFromClass(pluginClass);
        if (plugin == null || !PluginUtilities.isSuitableCreateProjectFromFilePlugin(plugin, suffix)) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            errors.add(new MessageError(null, "File: " + fileName + "does not exist."));
            return null;
        }
        Project project = plugin.createProject(file, errors);
        return project;
    }

    private CreateProjectFromFilePlugin getCreateProjectFromFilePluginFromClass(Class pluginClass) {
        if (pluginClass == null) {
            return null;
        }
        Object plugin = null;
        try {
            plugin = pluginClass.newInstance();
            return plugin;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

